/*
 * XMultiOclock west@aa.cs.keio.ac.jp
 * getargs.c 
 */


#include "xmoclock.h"

void get_args(int fargc, char **fargv, int rcmode, char *rcfile)
{
	int i = 0;

	if(rcmode == 0){
		fargc--;
		fargv++;
	}else{
		fargv = (char **)malloc(sizeof(char *)*256);
		fp = fopen(rcfile, "r");
		while((fin = getc(fp)) != EOF){
			if(i == 0){
				while(fin == '#'){
					while('\n' != getc(fp));
					fin = getc(fp);
					*(fargv+fargc) = NULL;
					fargc++;
				}
			}
			if(fin != '\n'){
				rcfile[i] = fin;
				i++;
			}else{
				rcfile[i] = '\0';
				*(fargv+fargc) = (char *)malloc(sizeof(char)*strlen(rcfile)+1);
				strcpy(*(fargv+fargc), rcfile);
				fargc++;
				i = 0;
			}
		}
		fclose(fp);
	}

	for(i = 0; fargc > i;){
		if(fargv[i] == NULL){
			i++;
			continue;
		}
		if(debugflag == TRUE){
			printf("Option : %s is now evaluating.\n", fargv[i]);
		}
		if(0 == strcmp("-help", fargv[i])){
			usage(i, rcmode);
		}else if(0 == strcmp("-debug", fargv[i])){
			debugflag = TRUE;
			i += 1;
			continue;
		}else if(0 == strcmp("-display", fargv[i])){
			dispname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-width", fargv[i])){
			geom = TRUE;
			width = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-height", fargv[i])){
			geom = TRUE;
			height = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-geometry", fargv[i])){
			geom = TRUE;
			geomx = atoi(fargv[i+1]);
			geomy = atoi(fargv[i+2]);
			i += 3;
			continue;
		}else if(0 == strcmp("-xmoclockdir", fargv[i])){
			homeflag = TRUE;
			xmoclockdir = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-startrcfile", fargv[i])){
			homeflag = TRUE;
			startrcfile = fargv[i+1];
			startrcflag = TRUE;
			i += 2;
			continue;
		}else if(0 == strcmp("-thin", fargv[i])){
			thin = atoi(fargv[i+1]);
			hourthin = thin*1.1;
			minutethin = thin;
			secondthin = thin/2;
			gridthin = thin/3;
			gridthin2 = thin/3;
			i += 2;
			continue;
		}else if(0 == strcmp("-hourthin", fargv[i])){
			hourthin = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-minutethin", fargv[i])){
			minutethin = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-secondthin", fargv[i])){
			secondthin = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-flamelocate1", fargv[i])){
			flamelocate1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-flamelocate2", fargv[i])){
			flamelocate2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-hourlocate1", fargv[i])){
			hourlocate1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-hourlocate2", fargv[i])){
			hourlocate2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-minlocate1", fargv[i])){
			minlocate1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-minlocate2", fargv[i])){
			minlocate2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-seclocate1", fargv[i])){
			seclocate1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-seclocate2", fargv[i])){
			seclocate2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-jewel", fargv[i])){
			jewel = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-jewellocate", fargv[i])){
			jewellocate = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-date", fargv[i])){
			dateflag = TRUE;
			i++;
			continue;
		}else if(0 == strcmp("-nodate", fargv[i])){
			dateflag = FALSE;
			i++;
			continue;
		}else if(0 == strcmp("-datelocatex1", fargv[i])){
			dateflag = TRUE;
			datelocatex1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-datelocatex2", fargv[i])){
			dateflag = TRUE;
			datelocatex2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-datelocatey1", fargv[i])){
			dateflag = TRUE;
			datelocatey1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-datelocatey2", fargv[i])){
			dateflag = TRUE;
			datelocatey2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-gridlocate1", fargv[i])){
			gridflag = TRUE;
			gridlocate1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-gridlocate2", fargv[i])){
			gridflag = TRUE;
			gridlocate2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-grid2locate1", fargv[i])){
			gridflag = TRUE;
			grid2locate1 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-grid2locate2", fargv[i])){
			gridflag = TRUE;
			grid2locate2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-separate", fargv[i])){
			separate = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-dateformat", fargv[i])){
			dateflag = TRUE;
			dateformatflag = TRUE;
			dateformat = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-datefont", fargv[i])){
			dateflag = TRUE;
			defaultfontflag = TRUE;
			datefont = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-normal", fargv[i])){
			secondflag = FALSE;
			transparentflag = FALSE;
			i++;
			continue;
		}else if(0 == strcmp("-transparent", fargv[i])){
			secondflag = TRUE;
			gridflag = FALSE;
			transparentflag = TRUE;
			i++;
			continue;
		}else if(0 == strcmp("-revtransparent", fargv[i])){
			secondflag = TRUE;
			gridflag = FALSE;
			transparentflag = TRUE;
			revtransparentflag = TRUE;
			i++;
			continue;
		}else if(0 == strcmp("-nosecond", fargv[i])){
			secondflag = TRUE;
			i++;
			continue;
		}else if(0 == strcmp("-second", fargv[i])){
			secondflag = FALSE;
			i++;
			continue;
		}else if(0 == strcmp("-datefontsize", fargv[i])){
			defaultfontflag = FALSE;
			dateflag = TRUE;
			fontsize = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-bg", fargv[i])){
			bgcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-fg", fargv[i])){
			fgcolorname = fargv[i+1];
			jewelcolorname = fargv[i+1];
			hourcolorname = fargv[i+1];
			minutecolorname = fargv[i+1];
			secondcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-flamecolor", fargv[i])){
			fgcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-jewelcolor", fargv[i])){
			jewelcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-hourcolor", fargv[i])){
			hourcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-minutecolor", fargv[i])){
			minutecolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-secondcolor", fargv[i])){
			secondcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-datecolor", fargv[i])){
			datecolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-gridcolor", fargv[i])){
			gridcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-gridcolor2", fargv[i])){
			gridcolorname2 = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mbg", fargv[i])){
			mbgcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mfg", fargv[i])){
			mfgcolorname = fargv[i+1];
			mjewelcolorname = fargv[i+1];
			mhourcolorname = fargv[i+1];
			mminutecolorname = fargv[i+1];
			msecondcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mflamecolor", fargv[i])){
			mfgcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mjewelcolor", fargv[i])){
			mjewelcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mhourcolor", fargv[i])){
			mhourcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mminutecolor", fargv[i])){
			mminutecolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-msecondcolor", fargv[i])){
			msecondcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mdatecolor", fargv[i])){
			mdatecolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mgridcolor", fargv[i])){
			mgridcolorname = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-mgridcolor2", fargv[i])){
			mgridcolorname2 = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-ignorewm", fargv[i])){
			ignorewmflag = TRUE;
			i += 1;
			continue;
		}else if(0 == strcmp("-bifffile", fargv[i])){
			mailfile = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-update", fargv[i])){
			secondflag = TRUE;
			updatetime = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-nice", fargv[i])){
			nice(atoi(fargv[i+1]));
			i += 2;
			continue;
		}else if(0 == strcmp("-sleep", fargv[i])){
			sleeptime = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-alarmaction", fargv[i])){
			alarmflag = TRUE;
			alarmhour = atoi(fargv[i+1]);
			alarmminute = atoi(fargv[i+2]);
			alarmaction = fargv[i+3];
			i += 4;
			continue;
		}else if(0 == strcmp("-noalarmaction", fargv[i])){
			alarmflag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-houraction", fargv[i])){
			hourflag = TRUE;
			houraction = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-nohouraction", fargv[i])){
			hourflag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-halfaction", fargv[i])){
			halfflag = TRUE;
			halfaction = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-nohalfaction", fargv[i])){
			halfflag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-quarteraction", fargv[i])){
			quarterflag = TRUE;
			quarteraction = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-noquarteraction", fargv[i])){
			quarterflag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-button1action", fargv[i])){
			button1flag = TRUE;
			button1action = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-nobutton1action", fargv[i])){
			button1flag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-button2action", fargv[i])){
			button2flag = TRUE;
			button2action = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-nobutton2action", fargv[i])){
			button2flag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-button3action", fargv[i])){
			button3flag = TRUE;
			button3action = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-nobutton3action", fargv[i])){
			button3flag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-biffaction", fargv[i])){
			biffflag = TRUE;
			biffaction = fargv[i+1];
			afterbiffaction = fargv[i+2];
			i += 3;
			continue;
		}else if(0 == strcmp("-nobiffaction", fargv[i])){
			biffflag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-keyaction", fargv[i])){
			if(0 == isalpha(*fargv[i+1])) usage(i, rcmode);
			keyflag[tolower(*fargv[i+1])-'a'] = TRUE;
			keyaction[tolower(*fargv[i+1])-'a'] = fargv[i+2];
			i += 3;
			continue;
		}else if(0 == strcmp("-nokeyaction", fargv[i])){
			keyflag[tolower(*fargv[i+1])-'a'] = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-configureaction", fargv[i])){
			configureflag = TRUE;
			configurefile = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-noconfigureaction", fargv[i])){
			configureflag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-command", fargv[i])){
			commandflag = TRUE;
			commandstr = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-broken", fargv[i])){
			if(0 == strcmp(fargv[i+1], "reverse")){
				brokenflag = REVERSE;
			}else if(0 == strcmp(fargv[i+1], "fast")){
				brokenflag = FAST;
			}else if(0 == strcmp(fargv[i+1], "random")){
				brokenflag = RANDOM;
			}else usage(i, rcmode);
			i += 2;
			continue;
		}else if(0 == strcmp("-nobroken", fargv[i])){
			brokenflag = NORMAL;
			i += 1;
			continue;
		}else if(0 == strcmp("-drop", fargv[i])){
			dropflag = TRUE;
			i += 1;
			continue;
		}else if(0 == strcmp("-dropspeed", fargv[i])){
			dropspeed = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-nodrop", fargv[i])){
			if(NEXT == dropflag){
				dropflag = NEXT2;
			}
			i += 1;
			continue;
		}else if(0 == strcmp("-move", fargv[i])){
			moveflag = TRUE;
			movefile = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-nomove", fargv[i])){
			if(moveflag == TRUE){
				fclose(fpm);
			}
			moveflag = NEXT2;
			i += 1;
			continue;
		}else if(0 == strcmp("-quit", fargv[i])){
			exit(0);
			continue;
		}else if(0 == strcmp("-grid", fargv[i])){
			gridflag = TRUE;
			gridlength = sqrt(width*width+height*height)/60;
			grid2length = sqrt(width*width+height*height)/60;
			gridthin = thin/20;
			gridthin2 = thin/20;
			i += 1;
			continue;
		}else if(0 == strcmp("-nogrid", fargv[i])){
			gridflag = FALSE;
			i += 1;
			continue;
		}else if(0 == strcmp("-gridthin", fargv[i])){
			gridflag = TRUE;
			gridthin = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-gridthin2", fargv[i])){
			gridflag = TRUE;
			gridthin2 = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-gridlength", fargv[i])){
			gridflag = TRUE;
			gridlength = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-grid2length", fargv[i])){
			gridflag = TRUE;
			grid2length = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-bell", fargv[i])){
			bellflag = TRUE;
			bellcount = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-led", fargv[i])){
			ledflag = TRUE;
			lednum = atoi(fargv[i+1]);
			i += 2;
			continue;
		}else if(0 == strcmp("-noled", fargv[i])){
			ledflag = NEXT2;
			i += 1;
			continue;
		}else if(0 == strcmp("-title", fargv[i])){
			titleflag = TRUE;
			titlename = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-iconify", fargv[i])){
			iconflag = TRUE;
			i += 1;
			continue;
		}else if(0 == strcmp("-iconbmfile", fargv[i])){
			iconbmflag = TRUE;
			iconbmfile = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-iconbmmaskfile", fargv[i])){
			iconbmmaskflag = TRUE;
			iconbmmaskfile = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-leave", fargv[i])){
			leaveflag = TRUE;
			leavefile = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-noleave", fargv[i])){
			leaveflag = FALSE;
			i ++;
			continue;
		}else if(0 == strcmp("-enter", fargv[i])){
			enterflag = TRUE;
			enterfile = fargv[i+1];
			i += 2;
			continue;
		}else if(0 == strcmp("-noenter", fargv[i])){
			enterflag = FALSE;
			i ++;
			continue;
		}else{
			fprintf(stderr, "Option error. (%d)\n", i+1);
			exit(1);
		}
		i++;
	}
}

void usage(int errl, int rcmode)
{
	if(rcmode == 1){
		fprintf(stderr, "%s : Multi Oclock for X Window Ver."THISVERSION"\n",
			commandline);
		fprintf(stderr, "Error in initfile %s (%d)\n",rcfile, errl+1);
		exit(1);		
	}else{
		fprintf(stderr, "%s : Multi Oclock for X Window Ver."THISVERSION"\n",
			commandline);
		fprintf(stderr, "Option: -help\n");
		fprintf(stderr, "        -display displayname:screen.subscreen\n");
		fprintf(stderr, "        -geometry x y\n");
		fprintf(stderr, "        -title titlestr\n");
		fprintf(stderr, "        -width num\n");
		fprintf(stderr, "        -height num\n");
		fprintf(stderr, "        -update num\n");
		fprintf(stderr, "        -nice num\n");
		fprintf(stderr, "        -sleep num\n");
		fprintf(stderr, "        -xmoclockdir *dir_str\n");
		fprintf(stderr, "        -startrcfile *rcfile_str\n");
		fprintf(stderr, "        -thin num\n");
		fprintf(stderr, "        -hourthin num\n");
		fprintf(stderr, "        -minutethin num\n");
		fprintf(stderr, "        -secondthin num\n");
		fprintf(stderr, "        -flamelocate1 num\n");
		fprintf(stderr, "        -flamelocate2 num\n");
		fprintf(stderr, "        -hourlocate1 num\n");
		fprintf(stderr, "        -hourlocate2 num\n");
		fprintf(stderr, "        -minlocate1 num\n");
		fprintf(stderr, "        -minlocate2 num\n");
		fprintf(stderr, "        -seclocate1 num\n");
		fprintf(stderr, "        -seclocate2 num\n");
		fprintf(stderr, "        -jewel num\n");
		fprintf(stderr, "        -jewellocate num\n");
		fprintf(stderr, "        -grid\n");
		fprintf(stderr, "        -nogrid\n");
		fprintf(stderr, "        -gridlength num\n");
		fprintf(stderr, "        -grid2length num\n");
		fprintf(stderr, "        -gridthin num\n");
		fprintf(stderr, "        -gridthin2 num\n");
		fprintf(stderr, "        -gridlocate1 num\n");
		fprintf(stderr, "        -gridlocate2 num\n");
		fprintf(stderr, "        -grid2locate1 num\n");
		fprintf(stderr, "        -grid2locate2 num\n");
		fprintf(stderr, "        -separate num\n");
		fprintf(stderr, "        -date\n");
		fprintf(stderr, "        -nodate\n");
		fprintf(stderr, "        -dateformat *format_str\n");
		fprintf(stderr, "        -datefont *font_str\n");
		fprintf(stderr, "        -datefontsize num\n");
		fprintf(stderr, "        -datelocatex1 num\n");
		fprintf(stderr, "        -datelocatex2 num\n");
		fprintf(stderr, "        -datelocatey1 num\n");
		fprintf(stderr, "        -datelocatey2 num\n");
		fprintf(stderr, "        -transparent\n");
		fprintf(stderr, "        -revtransparent\n");
		fprintf(stderr, "        -normal\n");
		fprintf(stderr, "        -second\n");
		fprintf(stderr, "        -nosecond\n");
		fprintf(stderr, "        -(m)bg *color_str\n");
		fprintf(stderr, "        -(m)fg *color_str\n");
		fprintf(stderr, "        -(m)flamecolor *color_str\n");
		fprintf(stderr, "        -(m)jewelcolor *color_str\n");
		fprintf(stderr, "        -(m)hourcolor *color_str\n");
		fprintf(stderr, "        -(m)minutecolor *color_str\n");
		fprintf(stderr, "        -(m)secondcolor *color_str\n");
		fprintf(stderr, "        -(m)datecolor *color_str\n");
		fprintf(stderr, "        -(m)gridcolor *color_str\n");
		fprintf(stderr, "        -(m)gridcolor2 *color_str\n");
		fprintf(stderr, "        -ignorewm\n");
		fprintf(stderr, "        -bifffile *filename_str\n");
		fprintf(stderr, "        -houraction *initfile_str\n");
		fprintf(stderr, "        -nohouraction\n");
		fprintf(stderr, "        -halfaction *initfile_str\n");
		fprintf(stderr, "        -nohalfaction\n");
		fprintf(stderr, "        -quarteraction *initfile_str\n");
		fprintf(stderr, "        -noquarteraction\n");
		fprintf(stderr, "        -button1action *initfile_str\n");
		fprintf(stderr, "        -nobutton1action\n");
		fprintf(stderr, "        -button2action *initfile_str\n");
		fprintf(stderr, "        -nobutton2action\n");
		fprintf(stderr, "        -button3action *initfile_str\n");
		fprintf(stderr, "        -nobutton3action\n");
		fprintf(stderr, "        -alarmaction hour minute *initfile_str\n");
		fprintf(stderr, "        -noalarmaction\n");
		fprintf(stderr, "        -biffaction *initfile_str *initfile_str\n");
		fprintf(stderr, "        -nobiffaction\n");
		fprintf(stderr, "        -keyaction key *initfile_str\n");
		fprintf(stderr, "        -nokeyaction key\n");
		fprintf(stderr, "        -command *command_str\n");
		fprintf(stderr, "        -broken mode\n");
		fprintf(stderr, "        -nobroken\n");
		fprintf(stderr, "        -drop\n");
		fprintf(stderr, "        -dropspeed num\n");
		fprintf(stderr, "        -nodrop\n");
		fprintf(stderr, "        -move *movefile_str\n");
		fprintf(stderr, "        -nomove\n");
		fprintf(stderr, "        -bell num\n");
		fprintf(stderr, "        -led num\n");
		fprintf(stderr, "        -noled\n");
		fprintf(stderr, "        -enter *initfile_str\n");
		fprintf(stderr, "        -noenter\n");
		fprintf(stderr, "        -leave *initfile_str\n");
		fprintf(stderr, "        -noleave\n");
		fprintf(stderr, "        -iconify\n");
		fprintf(stderr, "        -iconbmfile *icon_bitmap_file_str\n");
		fprintf(stderr, "        -iconbmmaskfile *icon_bitmap_maskfile_str\n");
		fprintf(stderr, "        -quit\n");
	}
	exit(1);
}
