/*
 * XMultiOclock west@aa.cs.keio.ac.jp
 * ticktack.c
 */


#include "xmoclock.h"

int xmainloop(void)
{
	double scale;
	int i = 0, j = 0, k = 0;

	while((now == time(NULL)) || (FAST == brokenflag) ||
		(RANDOM == brokenflag)){
		if(XPending(disp) > 0){
			XNextEvent(disp, &ev);
			switch(ev.type){
			case ButtonPress:
				switch(ev.xbutton.button){
				case Button1:
					if(button1flag) action(button1action);
					break;
				case Button2:
					if(button2flag) action(button2action);
					break;
				case Button3:
					if(button3flag) action(button3action);
					break;
				}
				break;
			case KeyPress:
				if(1 == XLookupString(&ev.xkey, &fin, 1, &key, NULL)){
					if(keyflag[fin-'a']){
						action(keyaction[fin-'a']);
					}
				}
				break;
			case ConfigureNotify:
				if(NEXT == startrcflag){
					startrcflag = FALSE;
					break;
				}else if((FALSE != dropflag) || (FALSE != moveflag)) break;
				else{
					XGetGeometry(disp, win, &rwin, &i, &j, &wid, &hei, &k, &k);
					XTranslateCoordinates(disp, win, root, 0, 0,
						&geomx, &geomy, &child);
					scale = sqrt(wid*wid+hei*hei)/
						sqrt(width*width+height*height);
					hourthin = hourthin*scale;
					minutethin = minutethin*scale;
					secondthin = secondthin*scale;
					gridthin = gridthin*scale;
					gridthin2 = gridthin2*scale;
					gridlength = gridlength*scale;
					grid2length = grid2length*scale;
					separate = separate*scale;

					setattributes();

					fontsize = fontsize*(sqrt(wid*wid+hei*hei)/
						sqrt(width*width+height*height));
					jewel = jewel*(sqrt(wid*wid+hei*hei)/
						sqrt(width*width+height*height));
					if(FALSE == defaultfontflag){
						sprintf(datefont, DEFAULTFONT1"%d"DEFAULTFONT2,
							fontsize);
					}
					font_info = XLoadQueryFont(disp, datefont);
					XSetFont(disp, gc, font_info->fid);
					width = wid;
					height = hei;
					makeshape();
					drawoutline();
					drawshape();
					configureaction();
				}
				break;
			case ClientMessage:
				if((ev.xclient.message_type == at1) &&
					(ev.xclient.data.l[0] == at2)){
					exit(0);
				}
				break;
			case LeaveNotify:
				if(leaveflag){
					leaveaction();
				}
				break;
			case EnterNotify:
				if(enterflag){
					enteraction();
				}
				break;
			}
		}
		if(FAST == brokenflag){
			now += 10;
			drawshape();
			(void)usleep(100*sleeptime);
		}else if(RANDOM == brokenflag){
			drawshape();
			(void)usleep(100*sleeptime);
		}else{
			(void)usleep(100000);
		
		}
	}
	if(commandflag){
		commandflag = FALSE;
		(void)system(commandstr);
	}
	if(actflag){
		actflag = FALSE;
		if(startflag){
			return TRUE;
		}
	}
	drawshape();
	return FALSE;
}
