/*
 * XMultiOclock west@aa.cs.keio.ac.jp
 * init.c 
 */


#include "xmoclock.h"

void initall(int argc, char **argv)
{

	geom = FALSE;
	geomx = 0;
	geomy = 0;
	jewel = 6;
	fontsize = 10;
	dateflag = FALSE;
	secondflag = FALSE;
	startflag = FALSE;
	startrcflag = FALSE;
	defaultfontflag = FALSE;
	transparentflag = FALSE;
	revtransparentflag = FALSE;
	ignorewmflag = FALSE;
	actflag = FALSE;
	dateformatflag = FALSE;
	alarmflag = FALSE;
	biffflag = FALSE;
	hourflag = FALSE;
	halfflag = FALSE;
	quarterflag = FALSE;
	button1flag = FALSE;
	button2flag = FALSE;
	button3flag = FALSE;
	commandflag = FALSE;
	dropflag = FALSE;
	moveflag = FALSE;
	gridflag = TRUE;
	brokenflag = FALSE;
	bellflag = FALSE;
	ledflag = FALSE;
	monoflag = FALSE;
	debugflag = FALSE;
	iconflag = FALSE;
	configureflag = FALSE;
	iconbmflag = FALSE;
	iconbmmaskflag = FALSE;
	homeflag = FALSE;
	titleflag = FALSE;
	enterflag = FALSE;
	leaveflag = FALSE;

	updatetime = 1;
	mailsize = 0;
	hourlocate1 = 1;
	hourlocate2 = 1;
	minlocate1 = 2;
	minlocate2 = 3;
	seclocate1 = 2;
	seclocate2 = 3;
	flamelocate1 = 1;
	flamelocate2 = 5;
	datelocatex1 = 1;
	datelocatex2 = 1;
	datelocatey1 = 6;
	datelocatey2 = 4;
	gridlocate1 = 1;
	gridlocate2 = 5;
	grid2locate1 = 1;
	grid2locate2 = 5;
	jewellocate = 0;
	width = 150;
	height = 150;
	dropspeed = 1;
	thin = 10;
	hourthin = 6;
	minutethin = 5;
	secondthin = 2;
	alarmhour = 0;
	alarmminute = 0;
	gridthin = 2;
	gridthin2 = 4;
	gridlength = 5;
	grid2length = 5;
	bellcount = 5;
	separate = 2;
	sleeptime = 100;

	(void)nice(5);

	bgcolorname = "white";
	fgcolorname = "black";
	jewelcolorname = "black";
	hourcolorname = "black";
	minutecolorname = "black";
	secondcolorname = "black";
	datecolorname = "gray";
	gridcolorname = "black";
	gridcolorname2 = "black";

	mbgcolorname = "white";
	mfgcolorname = "black";
	mjewelcolorname = "black";
	mhourcolorname = "black";
	mminutecolorname = "black";
	msecondcolorname = "black";
	mdatecolorname = "black";
	mgridcolorname = "black";
	mgridcolorname2 = "black";
	titlename = "XMultiOclock";
	iconbmfile = "\0";
	iconbmmaskfile = "\0";

	dateformat = "%r %D";

	datefont = malloc(sizeof(int)*256);

	if(NULL != (homedir = getenv("XMOCLOCKDIR"))){
	}else if(NULL != (homedir = getenv("HOME"))){
	}else{
		(void)fprintf(stderr, "Can't getenv HOME\n");
		exit(1);
	}
	if(NULL != getenv("XMOCLOCKRC")){
		strcpy(firstfile, getenv("XMOCLOCKRC"));
	}else{
		strcpy(firstfile, ".xmoclockrc");
	}

	mailfile = malloc(sizeof(int)*256);

	strcpy(mailfile, "/usr/spool/mail/");
	(void)strcat(mailfile, getenv("USER"));

	strcpy(rcfile, homedir);
	strcat(rcfile, "/");
	strcat(rcfile, firstfile);
	strcpy(commandline, argv[0]);

	if(0 == access(rcfile, R_OK)){
		get_args(0, NULL, 1, rcfile);
	}

	get_args(argc, argv, 0, NULL);
	
	if(NULL == (disp = XOpenDisplay(dispname))){
		fprintf(stderr, "Can't open display.\n");
		fprintf(stderr,
			"Please set DISPLAY shell valuable or -display option.\n");
		exit(1);
	}
	root = RootWindow(disp, 0);
	XSynchronize(disp, True);

	winwidth = DisplayWidth(disp, 0);
	winheight = DisplayHeight(disp, 0);

	if(TRUE == homeflag){
		homedir = xmoclockdir;
	}
	if(TRUE == startrcflag){
		startrcflag = NEXT;
		strcpy(rcfile, homedir);
		strcat(rcfile, "/");
		strcat(rcfile, startrcfile);
		if(0 == access(rcfile, R_OK)){
			get_args(0, NULL, 1, rcfile);
		}else{
			fprintf(stderr, "Can't find file %s.\n", rcfile);
		}
	}

	makewindow();
}

void reinitwithfile(void)
{
	if(geomx < 0){
		geomx = winwidth+geomx-width;
	}
	if(geomy < 0){
		geomy = winheight+geomy-height;
	}

	if(FALSE == defaultfontflag){
		sprintf(datefont, DEFAULTFONT1"%d"DEFAULTFONT2, fontsize);
	}

	datelocatex = (double)(datelocatex1)/(double)(datelocatex1+datelocatex2);
	datelocatey = (double)(datelocatey1)/(double)(datelocatey1+datelocatey2);
	flamelocate = (double)(flamelocate1)/(double)(flamelocate1+flamelocate2)/2;
	gridlocate = (double)(gridlocate2)/(double)(gridlocate1+gridlocate2)/2;
	grid2locate = (double)(grid2locate2)/(double)(grid2locate1+grid2locate2)/2;
	hourlocate = (double)(hourlocate2)/(double)(hourlocate1+hourlocate2)/2;
	minlocate = (double)(minlocate2)/(double)(minlocate1+minlocate2)/2;
	seclocate = (double)(seclocate2)/(double)(seclocate1+seclocate2)/2;

	if(TRUE == revtransparentflag){
		monoflag = TRUE;
		white = 1; 
		black = 0;
		fgcolor = black;
		bgcolor = white;
		jewelcolor = black;
		hourcolor = black;
		minutecolor = black;
		secondcolor = black;
		datecolor = white;
		gridcolor = black;
		gridcolor2 = black;
	}else if(TRUE == transparentflag){
		monoflag = TRUE;
		black = 1;
		white = 0;
		fgcolor = black;
		bgcolor = white;
		jewelcolor = black;
		hourcolor = black;
		minutecolor = black;
		secondcolor = black;
		datecolor = black;
		gridcolor = black;
		gridcolor2 = black;
	}else if(1 == DefaultDepth(disp, 0)){
		monoflag = TRUE;
		white = BlackPixel(disp, 0);
		black = WhitePixel(disp, 0);
		bgcolor = XWGetColorByName(disp, mbgcolorname);
		fgcolor = XWGetColorByName(disp, mfgcolorname);
		jewelcolor = XWGetColorByName(disp, mjewelcolorname);
		hourcolor = XWGetColorByName(disp, mhourcolorname);
		minutecolor = XWGetColorByName(disp, mminutecolorname);
		secondcolor = XWGetColorByName(disp, msecondcolorname);
		datecolor = XWGetColorByName(disp, mdatecolorname);
		gridcolor = XWGetColorByName(disp, mgridcolorname);
		gridcolor2 = XWGetColorByName(disp, mgridcolorname2);
	}else{
		white = BlackPixel(disp, 0);
		black = WhitePixel(disp, 0);
		bgcolor = XWGetColorByName(disp, bgcolorname);
		fgcolor = XWGetColorByName(disp, fgcolorname);
		jewelcolor = XWGetColorByName(disp, jewelcolorname);
		hourcolor = XWGetColorByName(disp, hourcolorname);
		minutecolor = XWGetColorByName(disp, minutecolorname);
		secondcolor = XWGetColorByName(disp, secondcolorname);
		datecolor = XWGetColorByName(disp, datecolorname);
		gridcolor = XWGetColorByName(disp, gridcolorname);
		gridcolor2 = XWGetColorByName(disp, gridcolorname2);
	}

	if((TRUE == geom) && (FALSE == dropflag) && (FALSE == moveflag)){
		if(FALSE == startflag){
			sizehints.flags = (USPosition | USSize);
			XSetWMNormalHints(disp, win, &sizehints);
		}
		XMoveWindow(disp, win, geomx, geomy);
		XResizeWindow(disp, win, width, height);
		geom = FALSE;
	}
	if(TRUE == ignorewmflag){
		att.override_redirect = True;
		XChangeWindowAttributes(disp, win, CWOverrideRedirect, &att);
	}
	
	makeshape();

	gc = XCreateGC(disp, bitmap, 0, NULL);
	gc1 = XCreateGC(disp, bitmap, 0, NULL);
	gc2 = XCreateGC(disp, bitmap, 0, NULL);
	gc3 = XCreateGC(disp, bitmap, 0, NULL);
	gc4 = XCreateGC(disp, bitmap, 0, NULL);
	gc5 = XCreateGC(disp, bitmap, 0, NULL);
	gc6 = XCreateGC(disp, bitmap, 0, NULL);
	gc7 = XCreateGC(disp, bitmap, 0, NULL);
	gc8 = XCreateGC(disp, bitmap, 0, NULL);

	font_info = XLoadQueryFont(disp, datefont);
	XSetFont(disp, gc, font_info->fid);

	XSetForeground(disp, gc1, hourcolor);
	XSetForeground(disp, gc2, minutecolor);
	XSetForeground(disp, gc3, secondcolor);
	XSetForeground(disp, gc4, gridcolor);
	XSetForeground(disp, gc5, gridcolor2);
	XSetForeground(disp, gc6, bgcolor);
	XSetForeground(disp, gc7, bgcolor);
	XSetForeground(disp, gc8, bgcolor);

	setattributes();

	drawoutline();
	iconaction();
	titleaction();
}
