/*
 * XMultiOclock west@aa.cs.keio.ac.jp
 * draw.c
 */

#include "xmoclock.h"

void setattributes()
{
	XSetLineAttributes(disp, gc1, hourthin, LineSolid, CapRound, JoinRound);
	XSetLineAttributes(disp, gc2, minutethin, LineSolid, CapRound, JoinRound);
	XSetLineAttributes(disp, gc3, secondthin, LineSolid, CapRound, JoinRound);
	XSetLineAttributes(disp, gc4, gridthin, LineSolid, CapRound, JoinRound);
	XSetLineAttributes(disp, gc5, gridthin2, LineSolid, CapRound, JoinRound);
	XSetLineAttributes(disp, gc6, hourthin+separate, LineSolid, CapRound,
		JoinRound);
	XSetLineAttributes(disp, gc7, minutethin+separate, LineSolid, CapRound,
		JoinRound);
	XSetLineAttributes(disp, gc8, secondthin+separate, LineSolid, CapRound,
		JoinRound);
}

void makewindow(void)
{
	win = XCreateSimpleWindow(disp, root, geomx, geomy, width, height, 0,
		WhitePixel(disp, 0), BlackPixel(disp, 0));
	XStoreName(disp, win, titlename);
	XMapWindow(disp, win);
	XDefineCursor(disp, win, XCreateFontCursor(disp, CURSORNAME));
	if(FALSE == ignorewmflag){
		at1 = XInternAtom(disp, "WM_PROTOCOLS", False);
		at2 = XInternAtom(disp, "WM_DELETE_WINDOW", False);
		XSetWMProtocols(disp, win, &at2, 1);
	}
	XSelectInput(disp, win, KeyPressMask | ButtonPressMask |
		StructureNotifyMask | LeaveWindowMask | EnterWindowMask);
}

void drawoutline(void)
{
	double gridloop;
	int i;

	if(FALSE == transparentflag){
		bitmap2 = XCreatePixmap(disp, win, width, height,
			DefaultDepth(disp, 0));
		XSetForeground(disp, gc, white);
		XFillRectangle(disp, bitmap2, gc, 0, 0, width, height);
		XSetForeground(disp, gc, fgcolor);
		XFillArc(disp, bitmap2, gc, 0, 0, width, height, 0, 360*64);
		XSetForeground(disp, gc, bgcolor);
		XFillArc(disp, bitmap2, gc, width*flamelocate, height*flamelocate,
			width*(1-flamelocate*2), height*(1-flamelocate*2), 0, 360*64);
		if(TRUE == gridflag){
			for(i = 1; i <= 59; i++){
				gridloop = 2*PI/60*(double)i-PI/2;
				XDrawLine(disp, bitmap2, gc4,
					(width-gridlength)*gridlocate*cos(gridloop)+width/2,
					(height-gridlength)*gridlocate*sin(gridloop)+height/2,
					width*gridlocate*cos(gridloop)+width/2,
					height*gridlocate*sin(gridloop)+height/2);
			}
			for(i = 1; i <= 11; i++){
				gridloop = 2*PI/12*(double)i-PI/2;
				XDrawLine(disp, bitmap2, gc5,
					(width-grid2length)*grid2locate*cos(gridloop)+width/2,
					(height-grid2length)*grid2locate*sin(gridloop)+height/2,
					width*grid2locate*cos(gridloop)+width/2,
					height*grid2locate*sin(gridloop)+height/2);
			}
		}
		XSetForeground(disp, gc, jewelcolor);
		XFillArc(disp, bitmap2, gc, width/2-jewel/2,
			height/2-height*gridlocate-jewel/2+jewellocate,
			jewel, jewel, 0, 360*64);
	}else{
		XSetForeground(disp, gc, white);
		XFillRectangle(disp, bitmap, gc, 0, 0, width, height);
		XSetForeground(disp, gc, fgcolor);
		XFillArc(disp, bitmap, gc, 0, 0, width, height, 0, 360*64);
		XSetForeground(disp, gc, bgcolor);
		XFillArc(disp, bitmap, gc, width*flamelocate, height*flamelocate,
			width*(1-flamelocate*2), height*(1-flamelocate*2), 0, 360*64);
		XSetForeground(disp, gc, jewelcolor);
		XFillArc(disp, bitmap, gc, width/2-jewel/2,
			height/2-height*gridlocate-jewel/2+jewellocate, jewel, jewel,
			0, 360*64);
	}
}

void drawshape(void)
{
	struct tm *tm;
	double hour, minute, second;

	if((NORMAL == brokenflag) || (REVERSE == brokenflag)){
		time(&now);
	}else if(RANDOM == brokenflag){
		now = rand();
	}

	tm = localtime(&now);

	if(FALSE == transparentflag){
		XCopyArea(disp, bitmap2, bitmap, gc, 0, 0, width, height, 0, 0);
	}

	if(REVERSE == brokenflag){
		hour = -PI*2/12*(tm->tm_hour%12)-PI*2/720*tm->tm_min-PI/2;
		minute = -PI*2/60*tm->tm_min-PI*2/3600*tm->tm_sec-PI/2;
		second = -PI*2/60*tm->tm_sec-PI/2;
	}else{
		hour = PI*2/12*(tm->tm_hour%12)+PI*2/720*tm->tm_min-PI/2;
		minute = PI*2/60*tm->tm_min+PI*2/3600*tm->tm_sec-PI/2;
		second = PI*2/60*tm->tm_sec-PI/2;
	}
	if(TRUE == monoflag){
		XDrawLine(disp, bitmap, gc6, width/2, height/2,
			width*hourlocate*cos(hour)+width/2,
			height*hourlocate*sin(hour)+height/2);
	}
	XDrawLine(disp, bitmap, gc1, width/2, height/2,
	width*hourlocate*cos(hour)+width/2, height*hourlocate*sin(hour)+height/2);
	if(TRUE == monoflag){
		XDrawLine(disp, bitmap, gc7, width/2, height/2,
		width*minlocate*cos(minute)+width/2,
		height*minlocate*sin(minute)+height/2);
	}
	XDrawLine(disp, bitmap, gc2, width/2, height/2,
	width*minlocate*cos(minute)+width/2, height*minlocate*sin(minute)+height/2);
	if(FALSE == secondflag && TRUE == startflag){
		if(TRUE == monoflag){
			XDrawLine(disp, bitmap, gc8, width/2, height/2,
			width*seclocate*cos(second)+width/2,
			height*seclocate*sin(second)+height/2);
		}
		XDrawLine(disp, bitmap, gc3, width/2, height/2,
		width*seclocate*cos(second)+width/2,
		height*seclocate*sin(second)+height/2);
	}
	if(TRUE == dateflag){
		if(FALSE == dateformatflag){
			strcpy(timestrings, ctime(&now));
		}else{
			strftime(timestrings, 128, dateformat, tm);
		}
		if((FALSE == monoflag) || (TRUE == transparentflag)){
			XSetForeground(disp, gc, datecolor);
			XDrawString(disp, bitmap, gc,
				(width-XTextWidth(font_info, timestrings,
				strlen(timestrings)))*datelocatex,
				height*datelocatey, timestrings, strlen(timestrings));
		}else{
			XSetForeground(disp, gc, bgcolor);
			XDrawString(disp, bitmap, gc,
				(width-XTextWidth(font_info, timestrings,
				strlen(timestrings)))*datelocatex+1,
				height*datelocatey+1, timestrings, strlen(timestrings));
			XDrawString(disp, bitmap, gc,
				(width-XTextWidth(font_info, timestrings,
				strlen(timestrings)))*datelocatex+1,
				height*datelocatey-1, timestrings, strlen(timestrings));
			XDrawString(disp, bitmap, gc,
				(width-XTextWidth(font_info, timestrings,
				strlen(timestrings)))*datelocatex-1,
				height*datelocatey+1, timestrings, strlen(timestrings));
			XDrawString(disp, bitmap, gc,
				(width-XTextWidth(font_info, timestrings,
				strlen(timestrings)))*datelocatex-1,
				height*datelocatey-1, timestrings, strlen(timestrings));
			XSetForeground(disp, gc, datecolor);
			XDrawString(disp, bitmap, gc,
				(width-XTextWidth(font_info, timestrings,
				strlen(timestrings)))*datelocatex,
				height*datelocatey, timestrings, strlen(timestrings));
		}
	}
	if(TRUE == transparentflag){
		XShapeCombineMask(disp, win, ShapeBounding, 0, 0, bitmap, ShapeSet);
		drawoutline();
	}else{
		XSetWindowBackgroundPixmap(disp, win, bitmap);
		XClearWindow(disp, win);
	}
	mailaction();
	brokenaction();
	dropaction();
	moveacion();
	bellaction();
	ledaction();
	if(FALSE == startflag) startflag = TRUE;
	XFlush(disp);
}

void makeshape(void)
{
	bitmap = XCreatePixmap(disp, win, width, height, 1);
	gce = XCreateGC(disp, bitmap, 0, NULL);
	XSetForeground(disp, gce, 0);
	XFillRectangle(disp, bitmap, gce, 0, 0, width, height);
	XSetForeground(disp, gce, 1);
	XFillArc(disp, bitmap, gce, 0, 0, width, height, 0, 360*64);
	XShapeCombineMask(disp, win, ShapeBounding, 0, 0, bitmap, ShapeSet);
	if(FALSE == transparentflag){
		bitmap = XCreatePixmap(disp, win, width, height, DefaultDepth(disp, 0));
	}
}
