/*
 * XMultiOclock west@aa.cs.keio.ac.jp
 * action.c 
 */

#include "xmoclock.h"

void action(char *act)
{
	strcpy(rcfile, homedir);
	strcat(rcfile, "/");
	strcat(rcfile, act);
	if(0 == access(rcfile, R_OK)){
		get_args(0, NULL, 1, rcfile);
	}else{
		fprintf(stderr, "Can't find file %s.\n", rcfile);
	}
	actflag = TRUE;
	startrcflag = FALSE;
}

void mailaction()
{
	stat(mailfile, &buf);
	if((TRUE == biffflag) && (now%updatetime == 0)){
		if(0 != access(mailfile, R_OK)) mailsize = 0;
		if(buf.st_size > mailsize){
			mailsize = buf.st_size;
			action(biffaction);
		}else if(buf.st_size < mailsize){
			action(afterbiffaction);
			mailsize = 0;
		}
	}
}

void brokenaction()
{
	if(NORMAL == brokenflag){
		if((TRUE == alarmflag) && (NORMAL == brokenflag)){
			if((tm->tm_hour == alarmhour) && (tm->tm_min == alarmminute) &&
				(tm->tm_sec == 0)){
				action(alarmaction);
			}
		}
		if((TRUE == hourflag) && (tm->tm_min == 0) && (tm->tm_sec == 0)){
			action(houraction);
		}else if((TRUE == halfflag) && (tm->tm_sec == 0) &&
			((tm->tm_min == 30) || (tm->tm_min == 0))){
			action(halfaction);
		}else if((TRUE == quarterflag) && (tm->tm_sec == 0) &&
			((tm->tm_min == 45) || (tm->tm_min == 30) || (tm->tm_min == 15) ||
			(tm->tm_min == 0))){
			action(quarteraction);
		}
	}
}

void dropaction()
{
	switch(dropflag){
	case TRUE:
		XTranslateCoordinates(disp, win, root, 0, 0, &dropx, &dropy, &child);
		for(movetmp = 0; winheight > dropy + height;){
			movetmp += dropspeed;
			dropy += movetmp;
			XMoveWindow(disp, win, dropx, dropy);
		}
		XMoveWindow(disp, win, dropx, winheight-height);
		dropflag = NEXT;
		break;
	case NEXT2:
		XMoveWindow(disp, win, geomx, geomy);
		dropflag = FALSE;
	}
}

void moveacion()
{
	switch(moveflag){
	case TRUE:
		strcpy(rcfile, homedir);
		strcat(rcfile, "/");
		strcat(rcfile, movefile);
		if(NULL == (fpm = fopen(rcfile, "r"))){
			fprintf(stderr, "Can't find movefile %s.\n", rcfile);
			moveflag = FALSE;
			return;
		}
		moveflag = NEXT;
	case NEXT:
		if(EOF != fscanf(fpm, "%d%d", &dropx, &dropy)){
			if(dropx == -1){
				dropx = geomx;
				dropy = geomy;
			}else if(dropx == -2){
				dropx = geomx;
				dropy = geomy;
				fclose(fpm);
				moveflag = FALSE;
			}else if(dropx == -3){
				fclose(fpm);
				strcpy(rcfile, homedir);
				strcat(rcfile, "/");
				strcat(rcfile, movefile);
				fpm = fopen(rcfile, "r");
				fscanf(fpm, "%d%d", &dropx, &dropy);
			}
			XMoveWindow(disp, win, dropx, dropy);
		}else{
			fclose(fpm);
			moveflag = FALSE;
		}
		break;
	case NEXT2:
		moveflag = FALSE;
		break;
	}
}

void bellaction()
{
	if(TRUE == bellflag){
		bellcount--;
		XBell(disp, 0);
		if(bellcount == 0) bellflag = FALSE;
	}
}

void ledaction()
{
	switch(ledflag){
	case TRUE:
		keycontrol.led = lednum;
		keycontrol.led_mode = LedModeOn;
		XChangeKeyboardControl(disp, KBLed | KBLedMode, &keycontrol);
		ledflag = NEXT;
		break;
	case NEXT:
		keycontrol.led = lednum;
		keycontrol.led_mode = LedModeOff;
		XChangeKeyboardControl(disp, KBLed | KBLedMode, &keycontrol);
		ledflag = TRUE;
		break;
	case NEXT2:
		keycontrol.led = lednum;
		keycontrol.led_mode = LedModeOff;
		XChangeKeyboardControl(disp, KBLed | KBLedMode, &keycontrol);
		ledflag = FALSE;
		break;
	}
}

void iconaction()
{
	if(TRUE == iconbmflag){
		strcpy(rcfile, homedir);
		strcat(rcfile, "/");
		strcat(rcfile, iconbmfile);
		if(0 != access(rcfile, R_OK)){
			fprintf(stderr, "Can't find file %s.\n", rcfile);
			return;
		}
	}
	if(TRUE == iconbmmaskflag){
		strcpy(icontmp, homedir);
		strcat(icontmp, "/");
		strcat(icontmp, iconbmmaskfile);
		if(0 != access(rcfile, R_OK)){
			fprintf(stderr, "Can't find file %s.\n", icontmp);
			return;
		}
	}
	if(iconbmflag){
		XWDefineWMIconSetting(disp, win, iconflag, rcfile, icontmp);
	}
	if(iconflag){
		iconflag = FALSE;
		XIconifyWindow(disp, win, 0); 
	}
}

void configureaction()
{
	if(configureflag){
		action(configurefile);
	}
}

void titleaction()
{
	titleflag = FALSE;
	XStoreName(disp, win, titlename);
}

void enteraction()
{
	action(enterfile);
}

void leaveaction()
{
	action(leavefile);
}
