/* -*- C++ -*-
 * Copyright (c) 1995-1996 Tohru Kisuki
 *               1995-2001 Masaki Wakabayashi
 *               1998 Keisuke Inoue
 *      	 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "snoop_cache_element.h"

snoop_cache_element::snoop_cache_element()
{
	cache_ctl.connect_cache(cache_buf);
	processor().port_ref().connect(cache_ctl.local_bus_port());
	processor().port_ref().connect(trw.port_ref());
	insert_synchronous_unit(cache_ctl);
}

snoop_cache_element::snoop_cache_element(const snoop_cache_element& a)
	: inherited(a),
	  cache_buf(a.cache_buf),
	  trw(a.trw)
{
	cache_ctl.connect_cache(cache_buf);
	processor().port_ref().connect(cache_ctl.local_bus_port());
	processor().port_ref().connect(trw.port_ref());
	insert_synchronous_unit(cache_ctl);
}

snoop_cache_element& snoop_cache_element::operator=
	(const snoop_cache_element& a)
{
	if (&a != this) {
		inherited::operator=(a);
		cache_ctl = a.cache_ctl;
		cache_buf = a.cache_buf;
	}
	return *this;
}

void snoop_cache_element::set_processor_id(size_t a)
{
	inherited::set_processor_id(a);
	cache_ctl.id(a);
	trw.set_id(a);
}

void snoop_cache_element::set_shared_memory_area
	(snoop_cache_element::address_type a,
	 snoop_cache_element::size_type b)
{
	set_sysinfo("shared_memory_address", a);
	set_sysinfo("shared_memory_size", b);
	update_shared_memory_area();
}

void snoop_cache_element::set_sync_memory_area
	(snoop_cache_element::address_type a,
	 snoop_cache_element::size_type b)
{
	set_sysinfo("sync_memory_address", a);
	set_sysinfo("sync_memory_size", b);
	update_shared_memory_area();
}

void snoop_cache_element::update_shared_memory_area(void)
{
	address_type sh_top = shared_memory_address(),
				 sy_top = sync_memory_address();
	size_type sh_size = shared_memory_size(), sy_size = sync_memory_size();
	address_type sh_bot = sh_top + sh_size, sy_bot = sy_top + sy_size;
	address_type top = (sh_top < sy_top) ? sh_top : sy_top;
	address_type bot = (sh_bot > sy_bot) ? sh_bot : sy_bot;
	cache_ctl.set_shared_address(sh_top, sh_size);
	cache_ctl.set_sync_address(sy_top, sy_size);
	trw.set_valid_address(top, bot - top);
}

void snoop_cache_element::set_cache_size
	(snoop_cache_element::size_type a,
	 snoop_cache_element::size_type b,
	 size_t c)
{
	cache_buf.resize(a, b, c);
}

void snoop_cache_element::enable_trace(ostream& os)
{
	insert_synchronous_unit(trw);
	trw.connect_stream(os);
}

void snoop_cache_element::disable_trace()
{
	erase_synchronous_unit(trw);
	trw.disconnect_stream();
}

void snoop_cache_element::output(ostream& os) const
{
	os << cache_ctl.local_bus_port() << "--" << cache_ctl;
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

bool snoop_cache_element::output(ostream& os, const string&) const
{
	return false;
}
