/* -*- C++ -*-
 *
 * <<< fetch_and_dec_control_unit.h >>>
 *
 * --- Fetch & dec memory control unit class 'fetch_and_dec_control_unit'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef FETCH_AND_DEC_CONTROL_UNIT_H
#define FETCH_AND_DEC_CONTROL_UNIT_H 1

#include <isis/memory_control_unit.h>

template <class A, class D = A, size_t Dsz = sizeof(D), class Ch = char>
class fetch_and_dec_control_unit : public memory_control_unit<A, D, Dsz, Ch>
{
private:
	typedef fetch_and_dec_control_unit<A, D, Dsz, Ch> thisclass;
	typedef memory_control_unit<A, D, Dsz, Ch> inherited;
public:
	typedef typename inherited::address_type address_type;
	typedef typename inherited::data_type data_type;
	typedef typename inherited::memory_type memory_type;
protected:
	virtual data_type read(address_type a)
	{
		data_type val = inherited::read(a);
		if (val > 0) write(a, val - 1);
		return val;
	}
public:
	fetch_and_dec_control_unit(void);
	fetch_and_dec_control_unit(const thisclass&);
	virtual ~fetch_and_dec_control_unit();
};

template <class A, class D, size_t Dsz, class Ch>
fetch_and_dec_control_unit<A, D, Dsz, Ch>::fetch_and_dec_control_unit(void)
{}

template <class A, class D, size_t Dsz, class Ch>
fetch_and_dec_control_unit<A, D, Dsz, Ch>::fetch_and_dec_control_unit
	(const fetch_and_dec_control_unit<A, D, Dsz, Ch>& a)
	: inherited(a)
{}

template <class A, class D, size_t Dsz, class Ch>
fetch_and_dec_control_unit<A, D, Dsz, Ch>::~fetch_and_dec_control_unit()
{}

#endif /* FETCH_AND_DEC_CONTROL_UNIT_H */
