/*
 * <<< r3081_processing_element.cc >>>
 *
 * --- R3081 processing element class 'r3081_processing_element'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <iostream>
#include <isis/mips_executable.h>
#include "r3081_processing_element.h"

const r3081_processing_element::address_type
	r3081_processing_element::default_multi_io_area_address = 0xbfd00000;
const r3081_processing_element::size_type
	r3081_processing_element::default_multi_io_area_size = 0x100;

r3081_processing_element::r3081_processing_element(void)
{
	set_multi_io_area(default_multi_io_area_address,
		default_multi_io_area_size);
}

r3081_processing_element::r3081_processing_element
	(const r3081_processing_element& a)
	: inherited(a)
{}

r3081_processing_element::~r3081_processing_element()
{}

void r3081_processing_element::output(ostream& os) const
{
	os << pu;
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

bool r3081_processing_element::output(ostream& os, const string& s) const
{
	if (s == "pu") {
		os << pu;
		return true;
	}
	return pu.output(os, s);
}

bool r3081_processing_element::load(const char* a)
{
	ifstream file(a, ios::in | ios::nocreate);
	if (file.bad()) return false;
	mips_executable object_file;
	object_file.load_header(file);
	if (!object_file.is_valid()) return false;
	bool flag = object_file.load_body_to_memory(file, memory_map());
	if (flag) {
		pu.program_counter() = object_file.entry_point();
	}
	return flag;
}

void r3081_processing_element::disassemble
	(ostream& os,
	 r3081_processing_element::address_type top,
	 r3081_processing_element::size_type size) const
{
	mips_executable::disassemble(os, memory_map(), top, size);
}
