/* -*- C++ -*-
 *
 * <<< r3010_fgr.h >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_FGR_H
#define R3010_FGR_H 1

#include <isis/r3000_typedef.h>
#include "r3010_typedef.h"

class ostream;

class r3010_fgr
{
	r3000_word w[2];
	r3010_sfloat s[2];
	r3010_dfloat d;
	enum { fgr_words, fgr_singles, fgr_double } state;
public:
	void reset(void);
	r3000_word read_word(int idx);
	r3010_sfloat read_single(int idx);
	r3010_dfloat read_double(void);
	void write_word(int idx, r3000_word data);
	void write_single(int idx, r3010_sfloat data);
	void write_double(r3010_dfloat data);
	friend ostream& operator<<(ostream&, const r3010_fgr&);
};

#endif /* R3010_FGR_H */
