/*
 * <<< r3010_ext.cc >>>
 *
 * --- Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip>
#include <iostream>
#include "r3010_ext.h"
#include "r3010_add.h"
#include "r3010_fgr.h"
#include "r3010_fcr.h"
#include "r3010_inst.h"
#include "r3010_stage.h"
#include "r3010_forward.h"
#include "r3010.h"

void
r3010_ext::reset()
{
	timer = 0;
	timer_local = 0;
	state = ext_idle;

	stall_mode = false;
}

void
r3010_ext::start(int dst, r3010_fgr& val, r3010_inst::fmt_t type, bool stall)
{
	_dst = dst;
	_val = val;

	stall_mode = stall;

	switch( type ) {
	  case r3010_inst::FMT_S:
		timer = delay0_s;
		timer_local = delay1_s;
		break;
	  case r3010_inst::FMT_D:
		timer = delay0_d;
		timer_local = delay1_d;
		break;
	  default:
		cerr << "R3010_ext:Illegal format: why it didn't occur error at RD?" << endl;
		break;
	}

	state = ext_calc;
}

void
r3010_ext::clock()
{
	switch( state ) {
	  case ext_idle:
		break;
	  case ext_calc:
		--timer;
		if( --timer_local > 0 )
			break;

		state = ext_wait_adder;

	  case ext_wait_adder:
		if( fpa->ex_add().in_use() )
			break;

		fpa->ex_add().external( timer, _val, _dst, stall_mode );

		state = ext_delay;
		break;

	  case ext_delay:
		if( --timer > 0 )
			break;

		state = ext_idle;
		break;
	}
}

ostream&
operator<<( ostream& os, const r3010_ext& ext )
{
	static char *state_name[] = { "IDLE", "CALC", "WAITADDER", "DELAY" };
	os << state_name[ext.state];
	if( ext.state != r3010_ext::ext_idle ) {
		os << "[" << ext.timer << "," << ext.timer_local << "]"
		   << "($f" << ext._dst << "=" << ext._val << ")";
	}
	return os;
}
