/* -*- C++ -*-
 *
 * <<< r3010_base.h >>>
 *
 * --- This file contains the declarations of R3010 base class.
 *     Copyright (C) 1996-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_BASE_H
#define R3010_BASE_H 1

class ostream;
class r3010_stage;
class r3010_forward;
template <class T> class r3010_forwarder;
template <class T> class r3010_freelist;
class r3010_fgrbuf;
class r3010_fcrbuf;
class r3010_csr;
class r3010_bus;
class r3010_add;
class r3010_mul;
class r3010_div;

class r3010_base
{
private:
	static const int NFGR = 32;
	static const int NFCR = 32;
protected:
	int _debug_level;
	r3010_freelist<r3010_stage*> *freestage;
	//
	// pipeline stages
	r3010_stage *s_if, *s_rd, *s_alu, *s_mem, *s_wb, *s_fwb;
	void new_stage(), delete_stage();
	// forwarding data
	// r3010_forwarder<r3010_forward> *alu_forward, *mem_forward;
	r3010_forwarder<r3010_forward> *forward;
	// floating general registers
	r3010_fgrbuf *_fgr;
	// floating control registers
	r3010_fcrbuf *_fcr;
	r3010_csr* _csr;
	// register locks
	bool reg_lock[NFGR+NFCR];
	// bus controller
	r3010_bus *bus;
	// external calculator
	r3010_add *_add;
	r3010_mul *_mul;
	r3010_div *_div;
	friend class r3010_stage;
	friend class r3010_add;
	friend class r3010_mul;
	friend class r3010_div;
	friend ostream& operator<<(ostream&, const r3010_base&);
public:
	r3010_base(void);
	void reset(void);
	r3010_fgrbuf& fgr(void) const { return *_fgr; }
	r3010_fcrbuf& fcr(void) const { return *_fcr; }
	r3010_csr& csr(void) const { return *_csr; }
	bool lock_reg_p(int);
	void lock_reg(int);
	void release_reg(int);
	r3010_add& ex_add(void);
	r3010_mul& ex_mul(void);
	r3010_div& ex_div(void);
	// human interface (?)
	void show_all_fgr(ostream&) const;
	void show_all_fcr(ostream&) const;
	int debug_level(void) const { return _debug_level; }
};

#endif /* R3010_BASE_H */
