/*
 * <<< r3000_stall_buffer.cc >>>
 *
 * --- R3000 stall buffer class 'r3000_stall_buffer'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstring> // needed only for SGI C++ compiler
#include <iomanip> // needed only for SGI C++ compiler
#include <algorithm>
#include <iostream>
#include "r3000_stall_buffer.h"

r3000_stall_buffer::r3000_stall_buffer(void)
	: buf(),
	  tmp_buf(r3000_stall::stall_type_to_int
		(r3000_stall::MULTIPLY_UNIT_BUSY_FIXUP) + 1),
	  buffered_count(0)
{
	fill(tmp_buf.begin(), tmp_buf.end(), false);
}

r3000_stall_buffer::r3000_stall_buffer(const r3000_stall_buffer& a)
	: buf(a.buf),
	  tmp_buf(a.tmp_buf),
	  buffered_count(a.buffered_count)
{}

r3000_stall_buffer::~r3000_stall_buffer()
{}

void r3000_stall_buffer::fetch_inner(void)
{
	for (int id = 0; buffered_count > 0; id++) {
		if (tmp_buf[id]) {
			buf.push(r3000_stall::int_to_stall_type(id));
			tmp_buf[id] = false;
			buffered_count--;
		}
	}
}

void r3000_stall_buffer::output(ostream& os) const
{
	if (is_run_cycle()) {
		os << "empty";
	} else {
		for (size_t i = 0; i < buf.size(); i++) {
			switch (buf[i].type()) {
			case r3000_stall::MICRO_TLB_MISS_STALL:
				os << "micro_tlb_miss_stall";
				break;
			case r3000_stall::MULTI_PROCESSOR_STALL:
				os << "multiprocessor_stall";
				break;
			case r3000_stall::PARTIAL_WORD_STORES_FIXUP:
				os << "partial_word_stores_fixup";
				break;
			case r3000_stall::COPROCESSOR_IFETCH_BUSY_STALL:
				os << "coprocessor_ifetch_busy_stall";
				break;
			case r3000_stall::COPROCESSOR_IFETCH_BUSY_FIXUP:
				os << "coprocessor_ifetch_busy_fixup";
				break;
			case r3000_stall::COPROCESSOR_FETCH_BUSY_STALL:
				os << "coprocessor_fetch_busy_stall";
				break;
			case r3000_stall::COPROCESSOR_FETCH_BUSY_FIXUP:
				os << "coprocessor_fetch_busy_fixup";
				break;
			case r3000_stall::COPROCESSOR_OUTPUT_BUSY_STALL:
				os << "coprocessor_output_busy_stall";
				break;
			case r3000_stall::COPROCESSOR_OUTPUT_BUSY_FIXUP:
				os << "coprocessor_output_busy_fixup";
				break;
			case r3000_stall::INSTRUCTION_CACHE_MISS_STALL:
				os << "instruction_cache_miss_stall";
				break;
			case r3000_stall::INSTRUCTION_CACHE_MISS_REFILL:
				os << "instruction_cache_miss_refill";
				break;
			case r3000_stall::INSTRUCTION_CACHE_MISS_FIXUP:
				os << "instruction_cache_miss_fixup";
				break;
			case r3000_stall::INSTRUCTION_CACHE_MISS_FIXUP_TO_STREAMING:
				os << "instruction_cache_miss_fixup_to_streaming";
				break;
			case r3000_stall::UNCACHEABLE_INSTRUCTION_STALL:
				os << "uncacheable_instruction_stall";
				break;
			case r3000_stall::UNCACHEABLE_INSTRUCTION_FIXUP:
				os << "uncacheable_instruction_fixup";
				break;
			case r3000_stall::WRITE_BUSY_STALL:
				os << "write_busy_stall";
				break;
			case r3000_stall::WRITE_BUSY_FIXUP:
				os << "write_busy_fixup";
				break;
			case r3000_stall::DATA_CACHE_MISS_STALL_WFLUSH:
				os << "data_cache_miss_stall_wflush";
				break;
			case r3000_stall::DATA_CACHE_MISS_STALL:
				os << "data_cache_miss_stall";
				break;
			case r3000_stall::DATA_CACHE_MISS_REFILL:
				os << "data_cache_miss_refill";
				break;
			case r3000_stall::DATA_CACHE_MISS_FIXUP:
				os << "data_cache_miss_fixup";
				break;
			case r3000_stall::UNCACHEABLE_DATA_STALL_WFLUSH:
				os << "uncacheable_data_stall_wflush";
				break;
			case r3000_stall::UNCACHEABLE_DATA_STALL:
				os << "uncacheable_data_stall";
				break;
			case r3000_stall::UNCACHEABLE_DATA_FIXUP:
				os << "uncacheable_data_fixup";
				break;
			case r3000_stall::MULTIPLY_UNIT_BUSY_STALL:
				os << "multiply_unit_busy_stall";
				break;
			case r3000_stall::MULTIPLY_UNIT_BUSY_FIXUP:
				os << "multiply_unit_busy_fixup";
				break;
			}
			if (i < buf.size() - 1) os << ", ";
		}
	}
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}
