/* -*- C++ -*-
 *
 * <<< r3000_processing_element.h >>>
 *
 * --- R3000 processing element class 'r3000_processing_element'
 *     Copyright (C) 1997-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_PROCESSING_ELEMENT_H
#define R3000_PROCESSING_ELEMENT_H 1

#include <string>
#include <isis/generic_processing_element.h>
#include <isis/r3000_typedef.h>
#include <isis/r3000.h>
#include <isis/r3010.h>
#include <isis/r3000_directmap_cache.h>

class ostream;

class r3000_processing_element
	: public generic_processing_element<r3000, r3000_word, r3000_word,
										sizeof_r3000_word, char>
{
private:
	typedef r3000_processing_element thisclass;
	typedef generic_processing_element<r3000, r3000_word, r3000_word,
									   sizeof_r3000_word, char> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::char_type char_type;
	typedef inherited::size_type size_type;
	static const size_type sizeof_data_type = inherited::sizeof_data_type;
private:
	static const address_type default_multi_io_area_address;
	static const size_type default_multi_io_area_size;
	r3000_directmap_cache inst_cache;
	r3000_directmap_cache data_cache;
	r3010 fpa;
public:
	r3000_processing_element(void);
	r3000_processing_element(const thisclass&);
	virtual ~r3000_processing_element();
	virtual void output(ostream&) const;
	virtual bool output(ostream&, const string&) const;
	virtual bool load(const char*);
	virtual void disassemble(ostream&, address_type, size_type) const;
	void set_instruction_cache_size(size_type, size_type);
	void set_data_cache_size(size_type, size_type);
	bool is_connected_to_coprocessor(void) const
		{ return pu.is_connected_to_coprocessor(); }
	void connect_coprocessor(void);
	void disconnect_coprocessor(void);
};

#endif /* R3000_PROCESSING_ELEMENT_H */
