/* -*- C++ -*-
 *
 * <<< simple_cache_line.h >>>
 *
 * --- Simple cache line class 'simple_cache_line'
 *     Copyright (C) 1995-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef SIMPLE_CACHE_LINE_H
#define SIMPLE_CACHE_LINE_H 1

#include <iostream>
#include <iomanip>
#include <isis/cache_line_base.h>

template < class A, class D, class C = vector<D> >
class simple_cache_line : public cache_line_base<A, D, C>
{
public:
	typedef C container_type;
	typedef typename container_type::size_type size_type;
	typedef A address_type;
	typedef D data_type;
private:
	typedef cache_line_base<A, D, C> inherited;
	typedef simple_cache_line<A, D, C> thisclass;
	bool valid_flag;
public:
	simple_cache_line(void);
	explicit simple_cache_line(size_type);
	virtual ~simple_cache_line();
	virtual void output(ostream&) const;
	virtual bool is_valid(void) const { return valid_flag; }
	void set_valid(void) { valid_flag = true; }
	void set_invalid(void) { valid_flag = false; }
};

template <class A, class D, class C>
simple_cache_line<A, D, C>::simple_cache_line(void)
	: valid_flag(false)
{}

template <class A, class D, class C>
simple_cache_line<A, D, C>::simple_cache_line
	(simple_cache_line<A, D, C>::size_type x)
	: inherited(x),
	  valid_flag(false)
{}

template <class A, class D, class C>
simple_cache_line<A, D, C>::~simple_cache_line()
{}

template <class A, class D, class C>
void simple_cache_line<A, D, C>::output(ostream& os) const
{
	const char fill = os.fill();
	const long flags = os.flags();
	os << hex << setfill('0');
	if (!is_valid()) {
		os << "<invalid>";
	} else {
		os << setw(sizeof(address_type) * 2) << tag() << ':';
		for (size_type i = 0; i < size(); i++) {
			os << ' ' << setw(sizeof(data_type) * 2) << (*this)[i];
		}
	}
	os.fill(fill);
	os.flags(flags);
}

#endif /* SIMPLE_CACHE_LINE_H */
