/*
 * <<< network_packet_sender.h >>>
 *
 * --- Network packet sender class 'network_packet_sender'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef NETWORK_PACKET_SENDER_H
#define NETWORK_PACKET_SENDER_H

#include <isis/virtual_channel.h>
#include <isis/network_packet_base.h>

template <class T>
class network_packet_sender
{
private:
	typedef network_packet_sender thisclass;
	typedef T packet_type;
	virtual_channel_output ch_;
	size_t count_;
	packet_type* pkt_buf_;
public:
	network_packet_sender(void) : count_(0) {}
	network_packet_sender(const thisclass&) : count_(0) {}
	~network_packet_sender();
	void output(ostream&) const;
	const virtual_channel_output& channel(void) const { return ch_; }
	virtual_channel_output& channel(void) { return ch_; }
	bool empty(void) const { return count_ == 0; }
	bool full(void) const { return !empty(); }
	void put(packet_type* a)
		{ if (count_ == 0) pkt_buf_ = a, count_ = a->length(); }
	inline void clock(void);
};

template <class T>
inline ostream& operator<<(ostream& os, const network_packet_sender<T>& a)
{
	if (os) a.output(os);
	return os;
}

template <class T>
inline void network_packet_sender<T>::clock(void)
{
	if (count_ > 0 && !ch_.full(0)) {
		ch_.put(0, pkt_buf_);
		count_--;
	}
}

template <class T>
network_packet_sender<T>::~network_packet_sender()
{
	if (count_ > 0 && pkt_buf_->length() == count_) delete pkt_buf_;
}

template <class T>
void network_packet_sender<T>::output(ostream& os) const
{
	os << '[';
	if (count_ > 0) {
		os << *pkt_buf_ << ",sending:" << count_ << '/' << pkt_buf_->length();
	}
	os << ']';
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

#endif /* NETWORK_PACKET_SENDER_H */
