/*
 * <<< memory_map_test.cc >>>
 *
 * --- Test program for memory_map class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif // HAVE_CONFIG_H
#include <iostream>
#include "mapped_memory.h"
#include "memory_map.h"

#if (SIZEOF_INT >= 4)
 typedef unsigned int word;
#else // !(SIZEOF_INT >= 4)
 typedef unsigned long word;
#endif // !(SIZEOF_INT >= 4)
const size_t sizeof_word = 4;

int main(void)
{
	typedef unsigned int word;
	mapped_memory<word, word, sizeof_word> mem1(0, 0x10);	 // 0x00 - 0x0f
	mapped_memory<word, word, sizeof_word> mem2(0x20, 0x10); // 0x20 - 0x2f
	mapped_memory<word, word, sizeof_word> mem3(0x40, 0x10); // 0x40 - 0x4f
	mapped_memory<word, word, sizeof_word> mem4(0x60, 0x20); // 0x60 - 0x7f
	const int all_memory_size =
		mem1.size() + mem2.size() + mem3.size() + mem4.size();
	memory_map<word, word, sizeof_word> map;
	map.insert(mem1);
	map.insert(mem2);
	map.insert(mem3);
	map.insert(mem4);
	word adr = mem1.top();
	for (int i = 0; i < all_memory_size; i += sizeof_word) {
		while (!map.is_valid(adr)) adr += sizeof_word;
		map.write(adr, i);
		adr += sizeof_word;
	}
	cout << map << endl;
	mem1.set_top(0x40);	// 0x40 - 0x4f
	mem2.set_top(0x30);	// 0x30 - 0x3f
	mem3.set_top(0x20);	// 0x20 - 0x2f
	mem4.set_top(0);	// 0x00 - 0x1f
	map.update();
	cout << map << endl;
	map.dump(cout, mem3.top(), all_memory_size / 2);
	cout << endl;
	return 0;
}
