/*
 * <<< arbiter_test.cc >>>
 *
 * --- Test program for arbiter class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <algorithm>
#include <cstddef>
#include <cstdlib>
#include <iostream>
#include "arbiter.h"

#define rnd() ((unsigned int)((seed = 1566083941UL * seed + 1) >> 16))
static unsigned long seed = 1;

int rnd_user(int max)
{
	return (rnd() % max);
}

int main(int argc, char** argv)
{
	const int res = (argc >= 2) ? atoi(argv[1]) : 4;
	const int user = (argc >= 3) ? atoi(argv[2]) : 8;
	const int iter = (argc >= 4) ? atoi(argv[3]) : 10;
	arbiter arb(res, user);
	cout << "init state:" << endl << "   " << arb << endl;
	for (int i = 0; i < iter; i++) {
		cout << "iter " << i << ": ";
		int action_count = rnd_user(arb.user_count()) + 1;
		vector<bool> flag(arb.user_count());
		fill(flag.begin(), flag.end(), false);
		for (int j = 0; j < action_count; j++) {
			int id;
			do {
				id = rnd_user(arb.user_count());
			} while (flag[id]);
			flag[id] = true;
			cout << id;
			size_t k;
			for (k = 0; k < arb.resource_count(); k++) {
				if (arb.user(k) == id) {
					break;
				}
			}
			if (k == arb.resource_count()) {
				arb.request(id);
				cout << "-req";
			} else {
				arb.release(id);
				cout << "-rel";
			}
			if (j < action_count - 1) cout << ", ";
		}
		cout << endl << "   " << arb << endl;
		arb.update();
		for (size_t j = 0; j < arb.user_count(); j++) arb.cancel(j);
		arb.update();
		cout << "-> " << arb << endl;
	}
	return 0;
}
