/* -*- C++ -*-
 *
 * <<< arbiter.h >>>
 *
 * --- Arbiter class 'arbiter'
 *     Copyright (C) 1998-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef ARBITER_H
#define ARBITER_H 1

#ifdef DEBUG
# include <cassert>
#endif // DEBUG
#include <vector>
#include <isis/cyclic_queue.h>
#include <isis/root_object.h>

class ostream;

class arbiter : public root_object
{
public:
	typedef int id_type;						// must choose signed type
	typedef size_t size_type;
private:
	typedef arbiter thisclass;
	typedef root_object inherited;
	vector<id_type> user_;						// resource user's id table
	cyclic_queue<id_type> req_queue_;			// request queue
	cyclic_queue<id_type> can_queue_;			// cancel queue
	cyclic_queue<id_type> rel_queue_;			// release queue
	id_type prev_winner_;
public:
	arbiter(size_type = 0, size_type = 0);
	virtual ~arbiter();
	virtual void output(ostream&) const;
	size_type resource_count(void) const		// get all resource number
		{ return user_.size(); }
	void set_resource_count(size_type);			// set all resource number
	size_type user_count(void) const			// get all user number
		{ return req_queue_.max_size(); }
	void set_user_count(size_type);				// set all user number
	bool is_free(size_type a) const				// resource<a> is used?
		{ return user_[a] < 0; }
	id_type user(size_type a) const				// get user-id of resource<a>
		{ return user_[a]; }
	size_type request_count(void) const			// get request number
		{ return req_queue_.max_size(); }
	void request(id_type a)						// user<a> request a resource
	{
#ifdef DEBUG
		assert(a >= 0 && a < id_type(user_count()));
#endif // DEBUG
		req_queue_.push(a);
	}
	void cancel(id_type a)						// user<a> cancel his request
	{
#ifdef DEBUG
		assert(a >= 0 && a < id_type(user_count()));
#endif // DEBUG
		can_queue_.push(a);
	}
	void release(id_type a)						// user<a> release his resource
	{
#ifdef DEBUG
		assert(a >= 0 && a < id_type(user_count()));
#endif // DEBUG
		rel_queue_.push(a);
	}
	void clear(void);							// clear user table, queues
	void update(void);							// update user table, queues
	virtual id_type compete(id_type, id_type, id_type) const; // battle func.
};

#endif /* ARBITER_H */
