# Configure paths for ISIS

dnl AM_PATH_ISIS([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for ISIS, and define ISIS_CFLAGS and ISIS_LIBS
dnl
AC_DEFUN(AM_PATH_ISIS,
[dnl 
dnl Get the cflags and libraries from the isis-config script
dnl
	AC_ARG_WITH(isis-prefix,
							[  --with-isis-prefix=PFX      Prefix where ISIS is installed (optional)],
							isis_config_prefix="$withval",
							isis_config_prefix="")
	AC_ARG_WITH(isis-exec-prefix,
							[  --with-isis-exec-prefix=PFX Exec prefix where ISIS is installed (optional)],
							isis_config_exec_prefix="$withval",
							isis_config_exec_prefix="")
	AC_ARG_ENABLE(isistest,
								[  --disable-isistest          Do not try to compile and run a test ISIS program],
								, enable_isistest=yes)

	if test x$isis_config_exec_prefix != x ; then
		 isis_config_args="$isis_config_args --exec-prefix=$isis_config_exec_prefix"
		 if test x${ISIS_CONFIG+set} != xset ; then
				ISIS_CONFIG=$isis_config_exec_prefix/bin/isis-config
		 fi
	fi
	if test x$isis_config_prefix != x ; then
		 isis_config_args="$isis_config_args --prefix=$isis_config_prefix"
		 if test x${ISIS_CONFIG+set} != xset ; then
				ISIS_CONFIG=$isis_config_prefix/bin/isis-config
		 fi
	fi

	AC_PATH_PROG(ISIS_CONFIG, isis-config, no)
	min_isis_version=ifelse([$1], ,1.0.0,$1)
	AC_MSG_CHECKING(for ISIS - version >= $min_isis_version)
	no_isis=""
	if test "$ISIS_CONFIG" = "no" ; then
		no_isis=yes
	else
		ISIS_CFLAGS=`$ISIS_CONFIG $isis_config_args --cflags`
		ISIS_LIBS=`$ISIS_CONFIG $isis_config_args --libs`
		isis_config_major_version=`$ISIS_CONFIG $isis_config_args --version | \
					 sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
		isis_config_minor_version=`$ISIS_CONFIG $isis_config_args --version | \
					 sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
		isis_config_micro_version=`$ISIS_CONFIG $isis_config_args --version | \
					 sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
		if test "x$enable_isistest" = "xyes" ; then
			dnl not implemented...
			:
		fi
	fi
	if test "x$no_isis" = x ; then
		 AC_MSG_RESULT(yes)
		 ifelse([$2], , :, [$2])     
	else
		 AC_MSG_RESULT(no)
		 if test "$ISIS_CONFIG" = "no" ; then
			 echo "*** The isis-config script installed by ISIS could not be found"
			 echo "*** If ISIS was installed in PREFIX, make sure PREFIX/bin is in"
			 echo "*** your path, or set the ISIS_CONFIG environment variable to the"
			 echo "*** full path to isis-config."
		 else
			 if test -f conf.isistest ; then
				:
			 else
					echo "*** Could not run ISIS test program."
					CFLAGS="$ac_save_CFLAGS"
					LIBS="$ac_save_LIBS"
			 fi
		 fi
		 ISIS_CFLAGS=""
		 ISIS_LIBS=""
		 ifelse([$3], , :, [$3])
	fi
	AC_SUBST(ISIS_CFLAGS)
	AC_SUBST(ISIS_LIBS)
	rm -f conf.isistest
])

dnl Local Variables:
dnl tab-width: 2
dnl End:
