/* -*- C++ -*-
 *
 * <<< tracemaker.h >>>
 *
 * --- Tracemaker class 'tracemaker'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef TRACEMAKER_H
#define TRACEMAKER_H 1

#include <vector>
#include "multiprocessor.h"
#include "mapped_memory.h"
#include "tracemaker_element.h"

class tracemaker : public multiprocessor<tracemaker_element>
{
private:
	typedef tracemaker thisclass;
	typedef multiprocessor<tracemaker_element> inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::char_type char_type;
	typedef inherited::size_type size_type;
	typedef inherited::processor_type processor_type;
	typedef inherited::memory_map_type memory_map_type;
	typedef tracemaker_element processing_element_type;
	typedef processing_element_type::mapped_memory_type mapped_memory_type;
private:
	static const address_type default_shared_memory_address;
	static const size_type default_shared_memory_size;
	static const address_type default_sync_memory_address;
	static const size_type default_sync_memory_size;
	vector<tracemaker_element> pe;
	mapped_memory_type shmem;
	mapped_memory_type shfad;
public:
	tracemaker(void);
	explicit tracemaker(size_t);
	tracemaker(const thisclass&);
	virtual ~tracemaker();
	virtual void output(ostream&) const;
	virtual const processing_element_type& processing_element(size_t i) const
		{ return pe[i]; }
	virtual processing_element_type& processing_element(size_t i)
		{ return pe[i]; }
	virtual size_t processor_number(void) const { return pe.size(); }
	virtual void set_processor_number(size_t);
	const address_type& shared_memory_address(void) const
		{ return shmem.top(); }
	const size_type& shared_memory_size(void) const
		{ return shmem.size(); }
	const address_type& sync_memory_address(void) const
		{ return shfad.top(); }
	const size_type& sync_memory_size(void) const
		{ return shfad.size(); }
	void set_shared_memory_area(const address_type&, const size_type&);
	void set_sync_memory_area(const address_type&, const size_type&);
	void output_trace(ostream&) const;
	void enable_all_trace(void);
	void disable_all_trace(void);
	void enable_coprocessor(void);
	void enable_instruction_cache(void);
	void enable_data_cache(void);
	void disable_coprocessor(void);
	void disable_instruction_cache(void);
	void disable_data_cache(void);
	unsigned int shared_memory_read_wait(void) const
		{ return pe[0].shared_memory_read_wait(); }
	unsigned int shared_memory_write_wait(void) const
		{ return pe[0].shared_memory_write_wait(); }
	unsigned int sync_memory_read_wait(void) const
		{ return pe[0].sync_memory_read_wait(); }
	unsigned int sync_memory_write_wait(void) const
		{ return pe[0].sync_memory_write_wait(); }
	void shared_memory_read_wait(unsigned int);
	void shared_memory_write_wait(unsigned int);
	void sync_memory_read_wait(unsigned int);
	void sync_memory_write_wait(unsigned int);
};

#endif /* TRACEMAKER_H */
