/* -*- C++ -*-
 *
 * <<< shared_bus_element.h >>>
 *
 * --- Processing element for shared bus architecture class
 *     'shared_bus_element'
 *     Copyright (C) 1998-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef SHARED_BUS_ELEMENT_H
#define SHARED_BUS_ELEMENT_H 1

#include "r3000_typedef.h"
#include "r3081_processing_element.h"
#include "shared_bus_interface_unit.h"

class shared_bus_element : public r3081_processing_element
{
private:
	typedef shared_bus_element thisclass;
	typedef r3081_processing_element inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::char_type char_type;
	typedef inherited::size_type size_type;
	typedef inherited::processor_type processor_type;
	typedef inherited::memory_map_type memory_map_type;
	static const size_type sizeof_data_type = inherited::sizeof_data_type;
	typedef mapped_memory<address_type, data_type, sizeof_data_type, char_type>
		mapped_memory_type;
private:
	shared_bus_interface_unit<address_type, data_type> shbus_if;
	void update_shared_memory_area(void);
public:
	shared_bus_element(void);
	shared_bus_element(const thisclass&);
	const port& port_ref(void) const { return shbus_if.shared_bus_port(); }
	port& port_ref(void) { return shbus_if.shared_bus_port(); }
	virtual void set_processor_id(size_t);
	virtual const address_type& shared_memory_address(void) const
		{ return address_type(get_integer_sysinfo("shared_memory_address")); }
	virtual const size_type& shared_memory_size(void) const
		{ return size_type(get_integer_sysinfo("shared_memory_size")); }
	virtual const address_type& sync_memory_address(void) const
		{ return address_type(get_integer_sysinfo("sync_memory_address")); }
	virtual const size_type& sync_memory_size(void) const
		{ return size_type(get_integer_sysinfo("sync_memory_size")); }
	virtual void set_shared_memory_area(const address_type&, const size_type&);
	virtual void set_sync_memory_area(const address_type&, const size_type&);
};

#endif /* SHARED_BUS_ELEMENT_H */
