/*
 * <<< tracewriter_unit_test.cc >>>
 *
 * --- Test program for tracewriter_unit class
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <cstddef>
#include <cstdlib>
#include "random_access_processor.h"
#include "mapped_memory.h"
#include "memory_control_unit.h"
#include "tracewriter_unit.h"

typedef unsigned int word;

int main(int argc, char **argv)
{
	const word top = 0, size = 0x100;
	random_access_processor<word> pu;
	const size_t count = (argc > 1) ? atoi(argv[1]) : 20;
	mapped_memory<word> mem_buf(top, size);
	memory_control_unit<word> mem;
	tracewriter_unit<word> tr;
	pu.port_ref().connect(mem.port_ref());
	pu.port_ref().connect(tr.port_ref());
	pu.set_access_probability(.2);
	pu.set_read_probability(.8);
	pu.set_address(top, size);
	mem.connect_memory(mem_buf);
	mem.set_read_wait(4);
	mem.set_write_wait(4);
	tr.set_valid_address(top, size);
	tr.connect_stream(cout);
	for (size_t i = 0; i < count; i++) {
		pu.clock_in();
		mem.clock_in();
		tr.clock_in();
		pu.clock_out();
		mem.clock_out();
		tr.clock_out();
	}
	return 0;
}
