/*
 * <<< single_port_synchronous_unit.cc >>>
 *
 * --- Abstract single-port synchronous unit class
 *     'single_port_synchronous_unit'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "single_port_synchronous_unit.h"
#include "port.h"

#ifdef SINGLE_PORT_SYNCHRONOUS_UNIT_BACK_COMPAT

bool single_port_synchronous_unit::is_connected(void) const
{
	return port_ref().is_connected();
}

bool single_port_synchronous_unit::is_connected
	(const single_port_synchronous_unit::port_type& a) const
{
	return port_ref().is_connected(a);
}

bool single_port_synchronous_unit::is_connected
	(const single_port_synchronous_unit& a) const
{
	return port_ref().is_connected(a.port_ref());
}

void single_port_synchronous_unit::connect
	(single_port_synchronous_unit::port_type& a)
{
	port_ref().connect(a);
}

void single_port_synchronous_unit::connect(single_port_synchronous_unit& a)
{
	port_ref().connect(a.port_ref());
}

void single_port_synchronous_unit::disconnect(void)
{
	port_ref().disconnect();
}

void single_port_synchronous_unit::set_id
	(single_port_synchronous_unit::id_type a)
{
	port_ref().set_id(a);
}

#endif /* SINGLE_PORT_SYNCHRONOUS_UNIT_BACK_COMPAT */
