/* -*- C++ -*-
 *
 * <<< processor.h >>>
 *
 * --- Abstract processor class 'processor'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef PROCESSOR_H
#define PROCESSOR_H 1

#include <cstddef>
#include "single_port_synchronous_unit.h"
#include "register_file.h"

template <class A, class D = A>
class processor : public single_port_synchronous_unit
{
public:
	typedef A address_type;
	typedef D data_type;
	virtual const data_type& register_file(size_t) const = 0;
	virtual data_type& register_file(size_t) = 0;
	virtual const address_type& program_counter(void) const = 0;
	virtual address_type& program_counter(void) = 0;
	virtual bool is_halt(void) const = 0;
	virtual bool is_stall(void) const = 0;
	virtual bool is_reading(void) const = 0;
	virtual bool is_writing(void) const = 0;
	virtual bool is_user_mode(void) const = 0;
	virtual bool is_kernel_mode(void) const = 0;
	virtual void halt(void) = 0;
};

#endif /* PROCESSOR_H */
