/* -*- C++ -*-
 *
 * <<< root_object.h >>>
 *
 * --- Abstract root object class 'root_object'
 *     Copyright (C) 1997-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef ROOT_OBJECT_H
#define ROOT_OBJECT_H 1

class istream;
class ostream;

class root_object
{
private:
	typedef root_object thisclass;
public:
	virtual ~root_object() {}
	virtual bool check_invariant(void) const { return true; }
	virtual thisclass* new_object(void) const { return 0; }
	virtual thisclass* clone_object(void) const { return 0; }
	virtual void input(istream&) {}
	virtual void output(ostream&) const {}
};

istream& operator>>(istream&, root_object&);
ostream& operator<<(ostream&, const root_object&);

#endif /* ROOT_OBJECT_H */
