/* -*- C++ -*-
 *
 * <<< gdb_port.h >>>
 *
 * --- Communication with gdb port class 'gdb_port'
 *     Copyright (C) 1999-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef GDB_PORT_H
#define GDB_PORT_H 1

#include "isis_config.h"

#if USE_SOCKET

class gdb_port
{
private:
	static int char_to_int(char);
	static char int_to_char(int);
	bool udp_flag_;
	int port_;
	int socket_;
	int client_;
	void* client_adr_; // actual type is "struct sockaddr*"
	int client_adr_len_;
	bool is_ready(void) const
		{ return socket_ >= 0 && (udp_flag_ || client_ >= 0); }
	int getchar_tcp(void);
	int send_tcp(const char*, int);
	int send_udp(const char*, int);
	int receive_tcp(char*, int);
	int receive_udp(char*, int);
public:
	gdb_port(void);
	~gdb_port();
	bool is_tcp_mode(void) const { return !udp_flag_; }
	bool is_udp_mode(void) const { return udp_flag_; }
	void use_tcp(void) { udp_flag_ = false; }
	void use_udp(void) { udp_flag_ = true; }
	void set_port(int a) { port_ = a; }
	bool setup(void);
	void shutdown(void);
	void connect(void);
	void disconnect(void);
	int send(const char*);
	int receive(char*, int);
};

#else // !USE_SOCKET

class gdb_port
{
public:
	gdb_port(void) {}
	~gdb_port() {}
	bool is_tcp_mode(void) const { return false; }
	bool is_udp_mode(void) const { return false; }
	void use_tcp(void) {}
	void use_udp(void) {}
	void set_port(int) {}
	bool setup(void);
	void shutdown(void) {}
	void connect(void) {}
	void disconnect(void) {}
	int send(const char*) { return 0; }
	int receive(char*, int) { return 0; }
};

#endif // USE_SOCKET

#endif /* GDB_PORT_H */
