/* -*- C++ -*-
 *
 * <<< r3081.h >>>
 *
 * --- R3081 class 'r3081'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3081_H
#define R3081_H 1

#include <string>
#include "r3000.h"
#include "r3010.h"
#include "r3000_directmap_cache.h"

class ostream;

class r3081 : public r3000
{
private:
	typedef r3081 thisclass;
	typedef r3000 inherited;
public:
	typedef inherited::word_type word_type;
	static const size_t sizeof_word_type = inherited::sizeof_word_type;
private:
	static const word_type default_instruction_cache_size = 16 * 1024;
	static const word_type default_instruction_cache_line_size = 16;
	static const word_type default_data_cache_size = 4 * 1024;
	static const word_type default_data_cache_line_size = 16;
	r3010 fpa;
	r3000_directmap_cache inst_cache, data_cache;
	void connect_instruction_cache(r3000_directmap_cache&) {}
	void connect_data_cache(r3000_directmap_cache&) {}
	void connect_coprocessor(void) {}
	void disconnect_instruction_cache(void) {}
	void disconnect_data_cache(void) {}
	void disconnect_coprocessor(void) {}
public:
	r3081(void);
	r3081(const r3081&);
	virtual ~r3081();
	virtual bool output(ostream&, const string&) const;
	void enable_coprocessor(void);
	void enable_instruction_cache(void);
	void enable_data_cache(void);
	void disable_coprocessor(void);
	void disable_instruction_cache(void);
	void disable_data_cache(void);
};

#endif /* R3081_H */
