/* -*- C++ -*-
 *
 * <<< r3010_types.h >>>
 *
 * --- Definitions of types for R3010 'r3010_types'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3010_TYPES_H
#define R3010_TYPES_H 1

#include <cfloat>
#include "isis_config.h"

/* definition of s_float type for R3010 (single precision) */
#if (SIZEOF_FLOAT >= 4)
#	define S_FLOAT_IS_FLOAT 1
#	undef S_FLOAT_IS_DOUBLE
#	define SINGLE_FLOAT_MANT_DIG (FLT_MANT_DIG)
#	define SINGLE_FLOAT_MAX (FLT_MAX)
#	define SINGLE_FLOAT_MAX_EXP (FLT_MAX_EXP)
	typedef float s_float;
#elif (SIZEOF_DOUBLE >= 4)
#	undef S_FLOAT_IS_FLOAT
#	define S_FLOAT_IS_DOUBLE 1
#	define SINGLE_FLOAT_MANT_DIG (DBL_MANT_DIG)
#	define SINGLE_FLOAT_MAX (DBL_MAX)
#	define SINGLE_FLOAT_MAX_EXP (DBL_MAX_EXP)
	typedef double s_float;
#else /* (SIZEOF_DOUBLE < 4) */
#	error "Sizeof(double) is too small. Can't compile."
#endif

/* definition of d_float type for R3010 (double precision) */
#if (SIZEOF_FLOAT >= 8)
#	define D_FLOAT_IS_FLOAT 1
#	undef D_FLOAT_IS_DOUBLE
#	define DOUBLE_FLOAT_MANT_DIG (FLT_MANT_DIG)
#	define DOUBLE_FLOAT_MAX (FLT_MAX)
#	define DOUBLE_FLOAT_MAX_EXP (FLT_MAX_EXP)
	typedef float d_float;
#elif (SIZEOF_DOUBLE >= 8)
#	undef D_FLOAT_IS_FLOAT
#	define D_FLOAT_IS_DOUBLE 1
#	define DOUBLE_FLOAT_MANT_DIG (DBL_MANT_DIG)
#	define DOUBLE_FLOAT_MAX (DBL_MAX)
#	define DOUBLE_FLOAT_MAX_EXP (DBL_MAX_EXP)
	typedef double d_float;
#else /* (SIZEOF_DOUBLE < 8) */
#	error "Sizeof(double) is too small. Can't compile."
#endif

#endif /* R3010_TYPES_H */
