/* -*- C++ -*-
 *
 * <<< freelist.h >>>
 *
 * --- Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef FREELIST_H
#define FREELIST_H 1

template<class T>
class freelist
{
	class freelist_item {
		freelist_item* _next;

		T item;

	public:
		freelist_item() { _next = 0; item = 0; }
		T get() { return item; }
		void put( T d ) { item = d; }
		freelist_item* next() const { return _next; }
		void chain( freelist_item* d ) { _next = d; }
	};

	freelist_item *head;
	freelist_item *free;

	friend class debug;
public:
	freelist() { head = free = 0; }

	T get();
	void put( T );
};

template<class T>
T freelist<T>::get()
{
	freelist_item *i = head;

	if( i ) {
		head = head->next();
		i->chain( free );
		free = i;
		return i->get();
	}

	return 0;
}

template<class T>
void freelist<T>::put( T d )
{
	freelist_item *i = free;

	if( i )
		free = free->next();
	else
		i = new freelist_item;

	i->put( d );
	i->chain( head );
	head = i;
}

#endif /* FREELIST_H */
