/* -*- C++ -*-
 *
 * <<< r3000_write_buffer.h >>>
 *
 * --- R3000 write buffer class 'r3000_write_buffer'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_WRITE_BUFFER_H
#define R3000_WRITE_BUFFER_H 1

#include <utility>
#include "c_array.h"
#include "r3000_typedef.h"
#include "write_buffer.h"

class r3000_write_buffer
	: public write_buffer< r3000_word, r3000_word,
						   cyclic_queue< pair<r3000_word, r3000_word>,
										 c_array< pair<r3000_word,
												  r3000_word>, 4 > > >
{
private:
	typedef r3000_write_buffer thisclass;
	typedef write_buffer< r3000_word, r3000_word,
						  cyclic_queue< pair<r3000_word, r3000_word>,
										c_array< pair<r3000_word,
													  r3000_word>, 4 > > >
		inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::container_type container_type;
	typedef inherited::size_type size_type;
	r3000_write_buffer(void);
	r3000_write_buffer(const thisclass&);
	virtual ~r3000_write_buffer();
};

#endif /* R3000_WRITE_BUFFER_H */
