/* -*- C++ -*-
 *
 * <<< r3000_typedef.h >>>
 *
 * --- Definitions of types for R3000 'r3000_typedef'
 *     Copyright (C) 1996-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_TYPEDEF_H
#define R3000_TYPEDEF_H 1

#include <cstddef>
#include "isis_config.h"

// definition of word type for R3000
#if (SIZEOF_INT >= 4)
	typedef unsigned int unsigned_r3000_word;
	typedef int signed_r3000_word;
#else // SIZEOF_INT < 4
	typedef unsigned long unsigned_r3000_word;
	typedef long signed_r3000_word;
#endif // SIZEOF_INT
typedef unsigned_r3000_word r3000_word;

const size_t sizeof_r3000_word = 4;

#endif /* R3000_TYPEDEF_H */
