/* -*- C++ -*-
 *
 * <<< r3000_stall_buffer.h >>>
 *
 * --- R3000 stall buffer class 'r3000_stall_buffer'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_STALL_BUFFER_H
#define R3000_STALL_BUFFER_H 1

#include <algorithm>
#include <vector>
#include "root_object.h"
#include "r3000_stall.h"
#include "c_array.h"
#include "cyclic_queue.h"

class ostream;

class r3000_stall_buffer : public root_object
{
private:
	typedef r3000_stall_buffer thisclass;
	typedef root_object inherited;
	cyclic_queue< r3000_stall, c_array<r3000_stall, 32> > buf;
	vector<bool> tmp_buf;
	size_t buffered_count;
	void fetch_inner(void);
public:
	r3000_stall_buffer(void);
	r3000_stall_buffer(const r3000_stall_buffer&);
	virtual ~r3000_stall_buffer();
	virtual void output(ostream&) const;
	r3000_stall::stall_type type(void) const
		{ return buf.front().type(); }
	bool is_run_cycle(void) const { return buf.empty(); }
	bool is_stall_cycle(void) const { return !is_run_cycle(); }
	bool is_buffered(void) const { return buffered_count > 0; }
	bool have_next_stall(void) const { return buf.size() >= 2; }
	void push(r3000_stall::stall_type a)
		{ buffered_count++, tmp_buf[r3000_stall::stall_type_to_int(a)] = true; }
	void pop(void) { buf.pop(); }
	void streaming_to_instruction_cache_miss_refill(void)
		{ buf.push(r3000_stall::INSTRUCTION_CACHE_MISS_REFILL); }
	void change(r3000_stall a) { buf.front() = a; }
	inline void fetch(void);
	inline void clear(void);
};

inline void r3000_stall_buffer::fetch(void)
{
	if (!is_buffered()) return;
	fetch_inner();
}

inline void r3000_stall_buffer::clear(void)
{
	buf.clear();
	fill(tmp_buf.begin(), tmp_buf.end(), false);
}

#endif /* R3000_STALL_BUFFER_H */
