/* -*- C++ -*-
 *
 * <<< r3000_register_file.h >>>
 *
 * --- R3000 register file class 'r3000_register_file'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_REGISTER_FILE_H
#define R3000_REGISTER_FILE_H 1

#include <string>
#include "c_array.h"
#include "r3000_typedef.h"
#include "register_file.h"

class ostream;

class r3000_register_file
	: public register_file< r3000_word, c_array<r3000_word, 32> >
{
private:
	typedef r3000_register_file thisclass;
	typedef register_file< r3000_word, c_array<r3000_word, 32> > inherited;
public:
	typedef inherited::container_type container_type;
	typedef inherited::value_type value_type;
	typedef inherited::size_type size_type;
	static string register_name(int);
	static int register_number(const string&);
	r3000_register_file(void);
	r3000_register_file(const thisclass&);
	virtual ~r3000_register_file();
	virtual void output(ostream&) const;
	const value_type& zero(void) const { return (*this)[0]; }
	const value_type& at(void) const { return (*this)[1]; }
	const value_type& v0(void) const { return (*this)[2]; }
	const value_type& v1(void) const { return (*this)[3]; }
	const value_type& a0(void) const { return (*this)[4]; }
	const value_type& a1(void) const { return (*this)[5]; }
	const value_type& a2(void) const { return (*this)[6]; }
	const value_type& a3(void) const { return (*this)[7]; }
	const value_type& t0(void) const { return (*this)[8]; }
	const value_type& t1(void) const { return (*this)[9]; }
	const value_type& t2(void) const { return (*this)[10]; }
	const value_type& t3(void) const { return (*this)[11]; }
	const value_type& t4(void) const { return (*this)[12]; }
	const value_type& t5(void) const { return (*this)[13]; }
	const value_type& t6(void) const { return (*this)[14]; }
	const value_type& t7(void) const { return (*this)[15]; }
	const value_type& s0(void) const { return (*this)[16]; }
	const value_type& s1(void) const { return (*this)[17]; }
	const value_type& s2(void) const { return (*this)[18]; }
	const value_type& s3(void) const { return (*this)[19]; }
	const value_type& s4(void) const { return (*this)[20]; }
	const value_type& s5(void) const { return (*this)[21]; }
	const value_type& s6(void) const { return (*this)[22]; }
	const value_type& s7(void) const { return (*this)[23]; }
	const value_type& t8(void) const { return (*this)[24]; }
	const value_type& t9(void) const { return (*this)[25]; }
	const value_type& k0(void) const { return (*this)[26]; }
	const value_type& k1(void) const { return (*this)[27]; }
	const value_type& gp(void) const { return (*this)[28]; }
	const value_type& sp(void) const { return (*this)[29]; }
	const value_type& fp(void) const { return (*this)[30]; }
	const value_type& ra(void) const { return (*this)[31]; }
	value_type& zero(void) { return (*this)[0]; }
	value_type& at(void) { return (*this)[1]; }
	value_type& v0(void) { return (*this)[2]; }
	value_type& v1(void) { return (*this)[3]; }
	value_type& a0(void) { return (*this)[4]; }
	value_type& a1(void) { return (*this)[5]; }
	value_type& a2(void) { return (*this)[6]; }
	value_type& a3(void) { return (*this)[7]; }
	value_type& t0(void) { return (*this)[8]; }
	value_type& t1(void) { return (*this)[9]; }
	value_type& t2(void) { return (*this)[10]; }
	value_type& t3(void) { return (*this)[11]; }
	value_type& t4(void) { return (*this)[12]; }
	value_type& t5(void) { return (*this)[13]; }
	value_type& t6(void) { return (*this)[14]; }
	value_type& t7(void) { return (*this)[15]; }
	value_type& s0(void) { return (*this)[16]; }
	value_type& s1(void) { return (*this)[17]; }
	value_type& s2(void) { return (*this)[18]; }
	value_type& s3(void) { return (*this)[19]; }
	value_type& s4(void) { return (*this)[20]; }
	value_type& s5(void) { return (*this)[21]; }
	value_type& s6(void) { return (*this)[22]; }
	value_type& s7(void) { return (*this)[23]; }
	value_type& t8(void) { return (*this)[24]; }
	value_type& t9(void) { return (*this)[25]; }
	value_type& k0(void) { return (*this)[26]; }
	value_type& k1(void) { return (*this)[27]; }
	value_type& gp(void) { return (*this)[28]; }
	value_type& sp(void) { return (*this)[29]; }
	value_type& fp(void) { return (*this)[30]; }
	value_type& ra(void) { return (*this)[31]; }
};

#endif /* R3000_REGISTER_FILE_H */
