/* -*- C++ -*-
 *
 * <<< r3000_directmap_cache.h >>>
 *
 * --- R3000 directmap cache class 'r3000_directmap_cache'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_DIRECTMAP_CACHE_H
#define R3000_DIRECTMAP_CACHE_H 1

#include "simple_cache_line.h"
#include "directmap_cache.h"
#include "r3000_typedef.h"

class r3000_directmap_cache
	: public directmap_cache< simple_cache_line<r3000_word, r3000_word> >
{
private:
	typedef r3000_directmap_cache thisclass;
	typedef directmap_cache< simple_cache_line<r3000_word, r3000_word> >
		inherited;
public:
	typedef inherited::address_type address_type;
	typedef inherited::data_type data_type;
	typedef inherited::line_type line_type;
	r3000_directmap_cache(void);
	explicit r3000_directmap_cache(r3000_word, r3000_word);
	r3000_directmap_cache(const thisclass&);
	virtual ~r3000_directmap_cache();
};

#endif /* R3000_DIRECTMAP_CACHE_H */
