/* -*- C++ -*-
 *
 * <<< r3000_cp0.h >>>
 *
 * --- R3000 CP0 class 'r3000_cp0'
 *     Copyright (C) 1995-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3K_CP0_H
#define R3K_CP0_H 1

#include "root_object.h"
#include "r3000_typedef.h"
#include "r3000_cp0_register_file.h"

class ostream;

const r3000_word r3000_reset_exception_vector		   = 0xbfc00000UL;
const r3000_word r3000_utlb_exception_vector		   = 0x80000000UL;
const r3000_word r3000_other_exception_vector		   = 0x80000080UL;
const r3000_word r3000_utlb_exception_vector_with_bev  = 0xbfc00100UL;
const r3000_word r3000_other_exception_vector_with_bev = 0xbfc00180UL;

class r3000_cp0 : public root_object
{
private:
	typedef r3000_cp0 thisclass;
	typedef root_object inherited;
	r3000_cp0_register_file rf;
public:
	const r3000_cp0_register_file& register_file(void) const { return rf; }
	r3000_cp0_register_file& register_file(void) { return rf; }
	r3000_cp0(void);
	r3000_cp0(const thisclass&);
	virtual ~r3000_cp0();
	virtual void output(ostream&) const;
	static r3000_word reset_exception_vector(void)
		{ return r3000_reset_exception_vector; }
	r3000_word utlb_exception_vector(void) const
	{ return (rf.is_bootstrap_exception_vectors()) ?
	  r3000_utlb_exception_vector_with_bev : r3000_utlb_exception_vector; }
	r3000_word exception_vector(void) const
	{ return (rf.is_bootstrap_exception_vectors()) ?
	  r3000_other_exception_vector_with_bev : r3000_other_exception_vector; }
	bool is_user_mode(void) const { return rf.is_user_mode_current(); }
	bool is_kernel_mode(void) const { return !is_user_mode(); }
	void set_user_mode(void) { rf.set_user_mode_current(); }
	void set_kernel_mode(void) { rf.reset_user_mode_current(); }
	void reset(void);
};

#endif /* R3K_CP0_H */
