/* -*- C++ -*-
 *
 * <<< r3000.h >>>
 *
 * --- R3000 class 'r3000'
 *     Copyright (C) 1995-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef R3000_H
#define R3000_H 1

#include <string>
#include "r3000_typedef.h"
#include "port.h"
#include "r3000_base.h"
#include "r3000_bus_interface.h"
#include "r3000_memory_access_unit.h"
#include "r3000_write_buffer_unit.h"
#include "r3000_integer_unit.h"
#include "r3000_cp0.h"

class ostream;
class r3000_directmap_cache;
class r3010;

class r3000 : public r3000_base
{
private:
	typedef r3000 thisclass;
	typedef r3000_base inherited;
public:
	typedef inherited::word_type word_type;
	static const size_t sizeof_word_type = sizeof_r3000_word;
private:
	r3000_bus_interface bus_if;
	r3000_cp0 cp0;
	r3000_memory_access_unit ma_unit;
	r3000_write_buffer_unit wb_unit;
	r3000_integer_unit int_unit;
	bool halt_flag;
public:
	r3000(void);
	r3000(const thisclass&);
	virtual ~r3000();
	virtual void output(ostream&) const;
	virtual bool output(ostream&, const string&) const;
	inline virtual const word_type& register_file(size_t i) const
		{ return int_unit.register_file(i); }
	inline virtual word_type& register_file(size_t i)
		{ return int_unit.register_file(i); }
	inline virtual const word_type& program_counter(void) const
		{ return int_unit.pc(); }
	inline virtual word_type& program_counter(void)
		{ return int_unit.pc(); }
	inline virtual bool is_halt(void) const
		{ return halt_flag; }
	inline virtual bool is_stall(void) const
		{ return int_unit.is_stall_cycle(); }
	inline virtual bool is_reading(void) const
		{ return ma_unit.is_reading(); }
	inline virtual bool is_writing(void) const
		{ return ma_unit.is_writing(); }
	inline virtual bool is_user_mode(void) const
		{ return cp0.is_user_mode(); }
	inline virtual bool is_kernel_mode(void) const
		{ return cp0.is_kernel_mode(); }
	inline virtual void clock_in(void);
	inline virtual void clock_out(void);
	virtual void reset(void);
	virtual void halt(void);
	virtual const port& port_ref(void) const { return bus_if; }
	virtual port& port_ref(void) { return bus_if; }
	virtual bool is_connected_to_instruction_cache(void) const
		{ return ma_unit.is_connected_to_instruction_cache(); }
	virtual bool is_connected_to_data_cache(void) const
		{ return ma_unit.is_connected_to_data_cache(); }
	virtual bool is_connected_to_coprocessor(void) const
		{ return int_unit.is_connected_to_coprocessor(); }
	virtual void connect_instruction_cache(r3000_directmap_cache&);
	virtual void connect_data_cache(r3000_directmap_cache&);
	virtual void connect_coprocessor(r3010&);
	virtual void disconnect_instruction_cache(void);
	virtual void disconnect_data_cache(void);
	virtual void disconnect_coprocessor(void);
	inline word_type hi(void) const { return int_unit.hi(); }
	inline word_type lo(void) const { return int_unit.lo(); }
};

inline void r3000::clock_in(void)
{
	ma_unit.clock_in();
	wb_unit.clock_in();
	int_unit.clock();
}

inline void r3000::clock_out(void)
{
	wb_unit.clock_out();
	ma_unit.clock_out();
}

#endif /* R3000_H */
