/*
 * <<< r3000.cc >>>
 *
 * --- R3000 class 'r3000'
 *     Copyright (C) 1995-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <string>  // needed only for SGI C++ compiler
#include <iomanip> // needed only for SGI C++ compiler
#include <iostream>
#include "r3000.h"
#include "r3010.h"
#include "r3000_directmap_cache.h"

r3000::r3000(void)
	: bus_if(),
	  cp0(),
	  ma_unit(bus_if, cp0.register_file()),
	  wb_unit(ma_unit),
	  int_unit(ma_unit, wb_unit, cp0),
	  halt_flag(false)
{}

r3000::r3000(const r3000& a)
	: bus_if(a.bus_if),
	  cp0(a.cp0),
	  ma_unit(a.ma_unit, bus_if, cp0.register_file()),
	  wb_unit(a.wb_unit, ma_unit),
	  int_unit(a.int_unit, ma_unit, wb_unit, cp0),
	  halt_flag(a.halt_flag)
{}

r3000::~r3000()
{}

void r3000::output(ostream& os) const
{
	os << int_unit;
#ifdef DEBUG
	os << "\nwbu: " << wb_unit
	   << "\nmau: " << ma_unit
	   << "\nbus: " << bus_if;
	os.flush();
#endif // DEBUG
}

bool r3000::output(ostream& os, const string& s) const
{
	if (s == "bus_if" || s == "busif") {
		os << bus_if;
		return true;
	} else if (s == "ma_unit" || s == "mau") {
		os << ma_unit;
		return true;
	} else if (s == "write_buffer" || s == "wbuf") {
		os << wb_unit;
		return true;
	} else if (s == "cp0") {
		os << cp0;
		return true;
	} else if (s == "int_unit" || s == "int") {
		os << int_unit;
		return true;
	}
	return int_unit.output(os, s);
}

void r3000::reset(void)
{
	ma_unit.reset();
	wb_unit.reset();
	int_unit.reset();
	cp0.reset();
}

void r3000::halt(void)
{
	halt_flag = true;
}

void r3000::connect_instruction_cache(r3000_directmap_cache& a)
{
	if (a.cache_size() > 0) ma_unit.connect_instruction_cache(a);
}

void r3000::connect_data_cache(r3000_directmap_cache& a)
{
	if (a.cache_size() > 0) ma_unit.connect_data_cache(a);
}

void r3000::connect_coprocessor(r3010& a)
{
	int_unit.connect_coprocessor(a);
}

void r3000::disconnect_instruction_cache(void)
{
	ma_unit.disconnect_instruction_cache();
}

void r3000::disconnect_data_cache(void)
{
	ma_unit.disconnect_data_cache();
}

void r3000::disconnect_coprocessor(void)
{
	int_unit.disconnect_coprocessor();
}
