/* -*- C++ -*-
 *
 * <<< bus_port_base.h >>>
 *
 * --- Abstract bus port class 'bus_port_base'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef BUS_PORT_BASE_H
#define BUS_PORT_BASE_H 1

#ifdef DEBUG
# include <cassert>
#endif // DEBUG
#include <cstddef>
#include <iostream>
#include "port.h"
#include "bus_packet_base.h"

template <class A, class D = A>
class bus_port_base : public port
{
public:
	typedef typename bus_packet_base<A, D>::address_type address_type;
	typedef typename bus_packet_base<A, D>::data_type data_type;
private:
	typedef bus_port_base<A, D> thisclass;
	typedef port inherited;
	typedef bus_packet_base<A, D> packet_type;
public:
	bus_port_base(void);
	bus_port_base(const thisclass&);
	virtual ~bus_port_base();
	virtual void output(ostream&) const;
	const packet_type* look(void) const
		{ return (packet_type*)(inherited::look()); }
	packet_type* look(void)
		{ return (packet_type*)(inherited::look()); }
#ifndef DEBUG
	const packet_type& packet_reference(void) const { return *look(); }
	packet_type& packet_reference(void) { return *look(); }
#else // DEBUG
	const packet_type& packet_reference(void) const
		{ assert(look() != NULL);  return *look(); }
	packet_type& packet_reference(void)
		{ assert(look() != NULL);  return *look(); }
#endif // DEBUG
	const address_type& address(void) const
		{ return packet_reference().address(); }
	address_type& address(void)
		{ return packet_reference().address(); }
	const data_type& data(void) const
		{ return packet_reference().data(); }
	data_type& data(void)
		{ return packet_reference().data(); }
	size_t total_packet_count(void) const
		{ return packet_reference().total_packet_count(); }
	size_t packet_number(void) const
		{ return packet_reference().packet_number(); }
	bool is_ready(void) const
		{ return !have_packet(); }
	// is_{single,multi}()
	bool is_single(void) const
		{ return have_packet() && packet_reference().is_single(); }
	bool is_multi(void) const
		{ return have_packet() && packet_reference().is_multi(); }
	// is_{read,write}()
	bool is_read(void) const
		{ return have_packet() && packet_reference().is_read(); }
	bool is_write(void) const
		{ return have_packet() && packet_reference().is_write(); }
	// is_{request,grant,ack,nack,data}()
	bool is_request(void) const
		{ return have_packet() && packet_reference().is_request(); }
	bool is_grant(void) const
		{ return have_packet() && packet_reference().is_grant(); }
	bool is_ack(void) const
		{ return have_packet() && packet_reference().is_ack(); }
	bool is_nack(void) const
		{ return have_packet() && packet_reference().is_nack(); }
	bool is_data(void) const
		{ return have_packet() && packet_reference().is_data(); }
	// is_{read,write}_{request,grant,ack,nack,data}()
	bool is_read_request(void) const
		{ return have_packet() && packet_reference().is_read_request(); }
	bool is_read_grant(void) const
		{ return have_packet() && packet_reference().is_read_grant(); }
	bool is_read_ack(void) const
		{ return have_packet() && packet_reference().is_read_ack(); }
	bool is_read_nack(void) const
		{ return have_packet() && packet_reference().is_read_nack(); }
	bool is_read_data(void) const
		{ return have_packet() && packet_reference().is_read_data(); }
	bool is_write_request(void) const
		{ return have_packet() && packet_reference().is_write_request(); }
	bool is_write_grant(void) const
		{ return have_packet() && packet_reference().is_write_grant(); }
	bool is_write_ack(void) const
		{ return have_packet() && packet_reference().is_write_ack(); }
	bool is_write_nack(void) const
		{ return have_packet() && packet_reference().is_write_nack(); }
	bool is_write_data(void) const
		{ return have_packet() && packet_reference().is_write_data(); }
	// is_single_{read,write}_{request,grant,ack,nack,data}()
	bool is_single_read_request(void) const
		{ return have_packet() && packet_reference().is_single_read_request(); }
	bool is_single_read_grant(void) const
		{ return have_packet() && packet_reference().is_single_read_grant(); }
	bool is_single_read_ack(void) const
		{ return have_packet() && packet_reference().is_single_read_ack(); }
	bool is_single_read_nack(void) const
		{ return have_packet() && packet_reference().is_single_read_nack(); }
	bool is_single_read_data(void) const
		{ return have_packet() && packet_reference().is_single_read_data(); }
	bool is_single_write_request(void) const
		{ return have_packet() && packet_reference().is_single_write_request();}
	bool is_single_write_grant(void) const
		{ return have_packet() && packet_reference().is_single_write_grant(); }
	bool is_single_write_ack(void) const
		{ return have_packet() && packet_reference().is_single_write_ack(); }
	bool is_single_write_nack(void) const
		{ return have_packet() && packet_reference().is_single_write_nack(); }
	bool is_single_write_data(void) const
		{ return have_packet() && packet_reference().is_single_write_data(); }
	// is_multi_{read,write}_{request,grant,ack,nack,data}()
	bool is_multi_read_request(void) const
		{ return have_packet() && packet_reference().is_multi_read_request(); }
	bool is_multi_read_grant(void) const
		{ return have_packet() && packet_reference().is_multi_read_grant(); }
	bool is_multi_read_ack(void) const
		{ return have_packet() && packet_reference().is_multi_read_ack(); }
	bool is_multi_read_nack(void) const
		{ return have_packet() && packet_reference().is_multi_read_nack(); }
	bool is_multi_read_data(void) const
		{ return have_packet() && packet_reference().is_multi_read_data(); }
	bool is_multi_write_request(void) const
		{ return have_packet() && packet_reference().is_multi_write_request(); }
	bool is_multi_write_grant(void) const
		{ return have_packet() && packet_reference().is_multi_write_grant(); }
	bool is_multi_write_ack(void) const
		{ return have_packet() && packet_reference().is_multi_write_ack(); }
	bool is_multi_write_nack(void) const
		{ return have_packet() && packet_reference().is_multi_write_nack(); }
	bool is_multi_write_data(void) const
		{ return have_packet() && packet_reference().is_multi_write_data(); }
};

template <class A, class D>
bus_port_base<A, D>::bus_port_base(void)
{}

template <class A, class D>
bus_port_base<A, D>::bus_port_base(const bus_port_base<A, D>& a)
	: inherited(a)
{}

template <class A, class D>
bus_port_base<A, D>::~bus_port_base()
{}

template <class A, class D>
void bus_port_base<A, D>::output(ostream& os) const
{
	if (!have_packet()) {
		os << "ready";
	} else {
		os << packet_reference();
	}
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

#endif /* BUS_PORT_BASE_H */
