/* -*- C++ -*-
 *
 * <<< register_file.h >>>
 *
 * --- Register file class 'register_file'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef REGISTER_FILE_H
#define REGISTER_FILE_H 1

#include <algorithm>
#include <cstddef>
#include <vector>
#include "root_object.h"

class istream;
class ostream;

template < class T, class C = vector<T> >
class register_file : public root_object
{
public:
	typedef C container_type;
	typedef typename C::value_type value_type;
	typedef typename C::size_type size_type;
	typedef typename C::reference reference;
	typedef typename C::const_reference const_reference;
private:
	typedef register_file<T, C> thisclass;
	typedef root_object inherited;
	C buf;
public:
	register_file(void);
	explicit register_file(size_type);
	register_file(const thisclass&);
	virtual ~register_file();
	const_reference operator[](size_type i) const { return buf[i]; }
	reference operator[](size_type i) { return buf[i]; }
	size_type size(void) const { return buf.size(); }
	void clear(void);
};

template <class T, class C>
register_file<T, C>::register_file(void)
{
	clear();
}

template <class T, class C>
register_file<T, C>::register_file(register_file<T, C>::size_type a)
	: buf(a)
{
	clear();
}

template <class T, class C>
register_file<T, C>::register_file(const register_file<T, C>& a)
	: buf(a.buf)
{}

template <class T, class C>
register_file<T, C>::~register_file()
{}

template <class T, class C>
void register_file<T, C>::clear(void)
{
	fill(buf.begin(), buf.end(), value_type(0));
}

#endif /* REGISTER_FILE_H */
