/* -*- C++ -*-
 *
 * <<< cache_line_base.h >>>
 *
 * --- Cache line base class 'cache_line_base'
 *     Copyright (C) 1995-1999 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef CACHE_LINE_BASE_H
#define CACHE_LINE_BASE_H 1

#include <algorithm>
#include <iostream>
#include <iomanip>
#include <vector>
#include "root_object.h"

template < class A, class D, class C = vector<D> >
class cache_line_base : public root_object
{
public:
	typedef C container_type;
	typedef typename C::size_type size_type;
	typedef A address_type;
	typedef D data_type;
private:
	typedef cache_line_base<A, D, C> thisclass;
	typedef root_object inherited;
	container_type buf;
	address_type tag_;
public:
	cache_line_base(void);
	explicit cache_line_base(size_type);
	cache_line_base(const thisclass&);
	virtual ~cache_line_base();
	virtual void output(ostream&) const;
	size_type size(void) const { return buf.size(); }
	void resize(size_type);
	const address_type& tag(void) const { return tag_; }
	address_type& tag(void) { return tag_; }
	const data_type& operator[](size_t i) const { return buf[i]; }
	data_type& operator[](size_t i) { return buf[i]; }
	virtual bool is_valid(void) const = 0;
	virtual bool is_hit(const address_type& a) const
		{ return a == tag_ && is_valid(); }
};

template <class A, class D, class C>
cache_line_base<A, D, C>::cache_line_base(void)
{
	fill(buf.begin(), buf.end(), data_type(0));
}

template <class A, class D, class C>
cache_line_base<A, D, C>::cache_line_base
	(typename cache_line_base<A, D, C>::size_type x)
	: buf(x)
{
	fill(buf.begin(), buf.end(), data_type(0));
}

template <class A, class D, class C>
cache_line_base<A, D, C>::cache_line_base
	(const cache_line_base<A, D, C>& a)
	: buf(a.buf)
{}

template <class A, class D, class C>
cache_line_base<A, D, C>::~cache_line_base()
{}

template <class A, class D, class C>
void cache_line_base<A, D, C>::resize
	(cache_line_base<A, D, C>::size_type a)
{
	buf.resize(a);
}

template <class A, class D, class C>
void cache_line_base<A, D, C>::output(ostream& os) const
{
	const char fill = os.fill();
	const long flags = os.flags();
	os << hex << setfill('0')
	   << setw(sizeof(address_type) * 2) << tag() << ':';
	for (size_t i = 0; i < size(); i++) {
		os << ' ' << setw(sizeof(data_type) * 2) << buf[i];
	}
	os.fill(fill);
	os.flags(flags);
#ifdef DEBUG
	os.flush();
#endif // DEBUG
}

#endif /* CACHE_LINE_BASE_H */
