/*
 * <<< shared_malloc.c >>>
 *
 * --- Synchronization library for isis with shared memory 'shared_malloc.c'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "shlib.h"
#include "multi_io_funcs.h"

#ifndef NULL
#define NULL 0
#endif /* NULL */

#define CACHE_LINE_SIZE 16

static char *shared_memory_address;
static size_t shared_memory_size;
static char *shared_memory_end;
static int shared_malloc_start_flag = 0;
static char *shared_malloc_freearea;

static void shared_malloc_init(void)
{
	int t;
	__multi_io_sysinfo_read_integer("shared_memory_address", &t);
	shared_memory_address = (char*)t + 0x100;
	__multi_io_sysinfo_read_integer("shared_memory_size", &t);
	shared_memory_size = (size_t)t;
	shared_memory_end = shared_memory_address + shared_memory_size;
	shared_malloc_freearea = shared_memory_address;
	shared_malloc_start_flag = 1;
}

void *shared_malloc(size_t size)
{
	if (size <= 0) return NULL;
	if (!shared_malloc_start_flag) shared_malloc_init();
	size = size + (CACHE_LINE_SIZE - size) % CACHE_LINE_SIZE;
		/* align to cache line size */
	if (shared_malloc_freearea + size < shared_memory_end) {
		char *val = shared_malloc_freearea;
		shared_malloc_freearea += size;
		return val;
	} else {
		return NULL;
	}
}

void shared_free(void *p) {}
