dnl Checks for package, version.
dnl CF_CHECK_VERSION(VERSION-FILE-NAME)
AC_DEFUN(CF_CHECK_VERSION, [
	AC_CACHE_CHECK(version file location, cf_cv_path_version_file, [
		if test -f ${srcdir}/$1; then
			cf_cv_path_version_file=${srcdir}/$1
		else
			cf_cv_path_version_file=`find ${srcdir} -name $1 | head -1`
		fi
	])
	if test -z "$cf_cv_path_version_file"; then
		AC_MSG_ERROR(Missing version file.)
	fi
	AC_CACHE_CHECK(package name, cf_cv_subst_package_name, [
		cf_cv_subst_package_name="`sed -n 's/^\([[a-zA-Z0-9_.]][[a-zA-Z0-9_.]]*\) *version.*$/\1/p' $cf_cv_path_version_file`"
		if test -z "$cf_cv_subst_package_name"; then
			AC_MSG_ERROR(Bad version file.)
		fi
	])
	PACKAGE="$cf_cv_subst_package_name"
	AC_CACHE_CHECK(version number, cf_cv_subst_version_number, [
		cf_cv_subst_version_number="`sed -n 's/^.*version *\([[0-9.]][[0-9.]]*\).*$/\1/p' $cf_cv_path_version_file`"
		if test -z "$cf_cv_subst_version_number"; then
			AC_MSG_ERROR(Bad version file.)
		fi
	])
	VERSION="$cf_cv_subst_version_number"
	dnl don't use cache for revision: revision is frequently updated
	AC_MSG_CHECKING(revision string)
	REVISION="`sed -n 's/^.*version.*(\(.*\))/\1/p' $cf_cv_path_version_file`"
	test -z "$REVISION" && REVISION=release
	AC_MSG_RESULT($REVISION)
	MAJOR_VERSION=`echo $VERSION | sed -n 's/^\([[0-9]][[0-9]]*\).*/\1/p'`
	MINOR_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
	MICRO_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
	test -z "$MICRO_VERSION" && MICRO_VERSION=0
	MAJOR_VERSION=`expr $MAJOR_VERSION + 0`
	MINOR_VERSION=`expr $MINOR_VERSION + 0`
	MICRO_VERSION=`expr $MICRO_VERSION + 0`
	AC_SUBST(PACKAGE)
	AC_SUBST(VERSION)
	AC_SUBST(REVISION)
	AC_SUBST(MAJOR_VERSION)
	AC_SUBST(MINOR_VERSION)
	AC_SUBST(MICRO_VERSION)
])

dnl Checks for option for specified command.
dnl CF_CHECK_OPTION(PROGRAM-VARIABLE, FLAG-VARIABLE, OPTION)
AC_DEFUN(CF_CHECK_OPTION, [
	changequote(<<,>>)dnl
	define(<<cacheval>>, translit(cf_cv_prog_$1_$3, +-, P_))dnl
	changequote([,])dnl
	AC_CACHE_CHECK(whether [$]$1 accepts $3, cacheval, [
		echo 'int main(void) { return 0; }' > conftest.$ac_ext
		if test -z "`[$]$1 [$]$2 $3 -c conftest.$ac_ext 2>&1`"; then
			cacheval=yes
		else
			cacheval=no
		fi
		rm -fr conftest*
	])
	if test x$cacheval = xyes; then
		if test ! x"`echo [$]$2 | sed -n 's,.*$3.*,x,p'`" = xx; then
			$2="[$]$2 $3"
		fi
	fi
])

dnl Local Variables:
dnl tab-width: 2
dnl End:
