/*
 * <<< mpi.h >>>
 *
 * --- OSIRIS implementation of MPI subset 'mpi.h'
 *     Copyright (C) 2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef __MPI_H
#define __MPI_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define MPI_VERSION 1
#define MPI_SUBVERSION 2

typedef enum {
	MPI_BYTE,
	MPI_CHAR,
	MPI_SHORT,
	MPI_INT,
	MPI_LONG,
	MPI_FLOAT,
	MPI_DOUBLE,
	MPI_UNSIGNED_CHAR,
	MPI_UNSIGNED_SHORT,
	MPI_UNSIGNED,
	MPI_UNSIGNED_LONG
	/* MPI_DATATYPE_NULL, MPI_PACKED */
	/* C: MPI_LONG_LONG_INT */
	/* Fortran: MPI_DOUBLE_COMPLEX, MPI_REAL{2,4,8}, MPI_INTEGER{1,2,4} */
} MPI_Datatype;

typedef enum {
	MPI_COMM_NULL,
	MPI_COMM_WORLD,
	MPI_COMM_SELF
} MPI_Comm;

typedef struct {
	int MPI_SOURCE;
	int MPI_TAG;
	int MPI_ERROR;
	int sizeof_message;
} MPI_Status;

typedef enum {
	MPI_SUCCESS,
	MPI_ERR_COMM,
	MPI_ERR_TYPE,
	MPI_ERR_OTHER
} __MPI_return_code;

int MPI_Init(int*, char***);
int MPI_Finalize(void);
int MPI_Abort(MPI_Comm, int);
int MPI_Get_version(int*, int*);
int MPI_Comm_rank(MPI_Comm, int*);
int MPI_Comm_size(MPI_Comm, int*);
int MPI_Send(void*, int, MPI_Datatype, int, int, MPI_Comm);
int MPI_Recv(void*, int, MPI_Datatype, int, int, MPI_Comm, MPI_Status*);
int MPI_Barrier(MPI_Comm);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __MPI_H */
