/*
 * <<< mpi_barrier.c >>>
 *
 * --- OSIRIS implementation of MPI subset 'mpi_barrier.c'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "mpi.h"

int MPI_Barrier(MPI_Comm comm)
{
	__MPI_return_code code;
	switch (comm) {
	case MPI_COMM_WORLD:
		/* not implemented */
		code = MPI_SUCCESS;
		break;
	case MPI_COMM_NULL:
		code = MPI_ERR_COMM;
		break;
	case MPI_COMM_SELF:
		/* nothing to do */
		code = MPI_SUCCESS;
		break;
	default:
		/* sorry, not implemented */
		code = MPI_ERR_COMM;
		break;
	}
	return (int)(code);
}
