/*
 * <<< sync_malloc.c >>>
 *
 * --- Synchronization library for isis with shared memory 'sync_malloc.c'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "shlib.h"
#include "multi_io_funcs.h"

#ifndef NULL
#define NULL 0
#endif /* NULL */

#define CACHE_LINE_SIZE 16

static char *sync_memory_address;
static int sync_memory_size;
static char *sync_memory_end;
static int sync_malloc_start_flag = 0;
static char *sync_malloc_freearea;

static void sync_malloc_init(void)
{
	int t;
	__multi_io_sysinfo_read_integer("sync_memory_address", &t);
	sync_memory_address = (char*)t + 0x100;
	__multi_io_sysinfo_read_integer("sync_memory_size", &t);
	sync_memory_size = (size_t)t;
	sync_memory_end = sync_memory_address + sync_memory_size;
	sync_malloc_freearea = sync_memory_address;
	sync_malloc_start_flag = 1;
}

void *sync_malloc(size_t size)
{
	if (size <= 0) return NULL;
	if (!sync_malloc_start_flag) sync_malloc_init();
	size = size + (CACHE_LINE_SIZE - size) % CACHE_LINE_SIZE;
		/* align to cache line size */
	if (sync_malloc_freearea + size < sync_memory_end) {
		char *val = sync_malloc_freearea;
		sync_malloc_freearea += size;
		return val;
	} else {
		return NULL;
	}
}

void sync_free(void *p) {}
