/*
 * <<< barrier.c >>>
 *
 * --- Synchronization library for isis with shared memory 'barrier.c'
 *     Copyright (C) 1997-2000 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include "shlib.h"
#include "multi_io_funcs.h"

static volatile unsigned int* barrier_table;
static volatile unsigned int* barrier_fad_table;
static volatile unsigned int* barrier_adr1;
static volatile unsigned int* barrier_adr2;
static volatile unsigned int* barrier_adr3;
static volatile unsigned int* barrier_end;
static volatile unsigned int* barrier_fad1;
static volatile unsigned int* barrier_fad2;
static int punum, puid, barrier_start_flag = 0;

#define rnd() ((unsigned)((seed = 1566083941UL * seed + 1) >> 16))
static unsigned long seed;

static void barrier_init(void)
{
	const int key = 0x12345678; /* magic key */
	punum = get_punum(), puid = get_puid();
	if (punum == 1) return;
	{
		int t;
		__multi_io_sysinfo_read_integer("shared_memory_address", &t);
		barrier_table = (volatile unsigned int*)t;
		__multi_io_sysinfo_read_integer("sync_memory_address", &t);
		barrier_fad_table = (volatile unsigned int*)t;
	}
	barrier_end = barrier_table;
	barrier_adr1 = barrier_table + 1;
	barrier_adr2 = barrier_table + 2;
	barrier_adr3 = barrier_table + 3;
	barrier_fad1 = barrier_fad_table;
	barrier_fad2 = barrier_fad_table + 1;
	seed = puid;
	if (puid == 0) {
		*barrier_fad1 = punum;	/* counter-1 */
		*barrier_adr1 = 0;		/* key-1 */
		*barrier_adr3 = key;	/* initialize is finished */
	} else {
		while (*barrier_adr3 != key);
	}
	barrier_start_flag = 1;
}

void barrier(void)
{
	volatile unsigned *a1, *a2, *f1, *f2;
	if (!barrier_start_flag) barrier_init();
	if (punum == 1) return;
	a1 = barrier_adr1;
	a2 = barrier_adr2;
	f1 = barrier_fad1;
	f2 = barrier_fad2;
	if (*f1 > 1) {					/* counter-1 */
		/* not last processor */
		while (!(*a1)) {			/* wait last processor using key-1 */
			volatile unsigned t;
			if (rnd() & 0x8000UL) t, t, t, t;
			if (rnd() & 0x8000UL) t, t, t, t;
			if (rnd() & 0x8000UL) t, t, t, t;
			if (rnd() & 0x8000UL) t, t, t, t;
		}
	} else {
		/* last processor */
		*f2 = punum;				/* last processor reset counter-2, */
		*a2 = 0;					/*				  locks key-2, */
		*a1 = 1;					/*				  unlocks key-1 */
	}
	if (*f2 > 1) {					/* counter-2 */
		/* not last processor */
		while (!(*a2)) {			/* wait last processor using key-2 */
			volatile unsigned t;
			if (rnd() & 0x8000UL) t, t, t, t;
			if (rnd() & 0x8000UL) t, t, t, t;
			if (rnd() & 0x8000UL) t, t, t, t;
			if (rnd() & 0x8000UL) t, t, t, t;
		}
	} else {
		/* last processor */
		*f1 = punum;				/* last processor reset counter-1, */
		*a1 = 0;					/*				  locks key-1, */
		*a2 = 1;					/*				  unlocks key-2 */
	}
	*barrier_end;					/* dummy address */
}
