/*
 * <<< mpi_local.c >>>
 *
 * --- OSIRIS implementation of MPI subset 'mpi_local.c'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

/* #define __MPI_LOCAL_DEBUG */

#include <stdlib.h>
#include <sys/types.h>
#include "mpi.h"
#include "mpi_local.h"
#include "osiris.h"
#include "first_cache.h"
#include "mpni_io_funcs.h"
#ifdef __MPI_LOCAL_DEBUG
# include <stdio.h>
#endif /* __MPI_LOCAL_DEBUG */

typedef enum {
	MPI_PACKET_TYPE_SEND,
	MPI_PACKET_TYPE_SEND_ACK
} mpi_packet_type;

typedef struct {
	int source;
	int destination;
	mpi_packet_type type;
	size_t length;
	size_t total_packet_number, packet_index;
	int tag;
} mpi_packet;

static int mpi_local_init_flag = 0;
static int mpi_local_punum = 0;
static int mpi_local_puid = 0;

size_t __mpi_local_get_sizeof_datatype(MPI_Datatype t)
{
	int sizeof_dtype;
	switch (t) {
	case MPI_CHAR:
	case MPI_UNSIGNED_CHAR:
		sizeof_dtype = 1; break;
	case MPI_SHORT:
	case MPI_UNSIGNED_SHORT:
		sizeof_dtype = sizeof(short); break;
	case MPI_INT:
	case MPI_UNSIGNED:
		sizeof_dtype = sizeof(int); break;
	case MPI_LONG:
	case MPI_UNSIGNED_LONG:
		sizeof_dtype = sizeof(long); break;
	case MPI_FLOAT:
		sizeof_dtype = sizeof(float); break;
	case MPI_DOUBLE:
		sizeof_dtype = sizeof(double); break;
	default:
		sizeof_dtype = 0; break;
	}
	return sizeof_dtype;
}

int __mpi_local_init(void)
{
#ifdef __MPI_LOCAL_DEBUG
	printf("__mpi_local_init(%d/%d):\n", get_puid(), get_punum());
#endif /* __MPI_LOCAL_DEBUG */
	if (mpi_local_init_flag) return 1;
	if (!__mpni_io_init()) return 0;
	mpi_local_punum = get_punum();
	mpi_local_puid = get_puid();
	mpi_local_init_flag = 1;
	return 1;
}

void __mpi_local_finalize(void)
{
#ifdef __MPI_LOCAL_DEBUG
	printf("__mpi_local_finalize(%d/%d):\n", mpi_local_puid, mpi_local_punum);
#endif /* __MPI_LOCAL_DEBUG */
	if (!mpi_local_init_flag) return;
	__mpni_io_finalize();
	mpi_local_init_flag = 0;
}

int __mpi_local_comm_rank(void)
{
	return mpi_local_puid;
}

int __mpi_local_comm_size(void)
{
	return mpi_local_punum;
}

__MPI_return_code __mpi_local_send
	(void* buf, size_t size, unsigned int dst, int tag)
{
#ifdef __MPI_LOCAL_DEBUG
	printf("__mpi_local_send(%d/%d):\n", mpi_local_puid, mpi_local_punum);
#endif /* __MPI_LOCAL_DEBUG */
	return MPI_SUCCESS;
}

__MPI_return_code __mpi_local_receive
	(void* buf, size_t size, unsigned int src, int tag, MPI_Status* status)
{
#ifdef __MPI_LOCAL_DEBUG
	printf("__mpi_local_receive(%d/%d):\n", mpi_local_puid, mpi_local_punum);
#endif /* __MPI_LOCAL_DEBUG */
	return MPI_SUCCESS;
}

__MPI_return_code __mpi_local_isend
	(void* buf, size_t size, unsigned int dst, int tag)
{
#ifdef __MPI_LOCAL_DEBUG
	printf("__mpi_local_isend(%d/%d - buf:%p,size:%d,dst:%d,tag:%d):\n",
		   mpi_local_puid, mpi_local_punum, buf, size, dst, tag);
#endif /* __MPI_LOCAL_DEBUG */
	return MPI_SUCCESS;
}

__MPI_return_code __mpi_local_ireceive
	(void* buf, size_t size, unsigned int src, int tag, MPI_Status* status)
{
#ifdef __MPI_LOCAL_DEBUG
	printf("__mpi_local_ireceive(%d/%d - buf:%p,size:%d,tag:%d):\n",
		   mpi_local_puid, mpi_local_punum, buf, size, tag);
#endif /* __MPI_LOCAL_DEBUG */
	return MPI_SUCCESS;
}
