/*
 * <<< mpni_io_funcs.h >>>
 *
 * --- Communication routines with isis::mp_network_interface
 *     'mpni_io_funcs'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef MPNI_IO_FUNCS_H
#define MPNI_IO_FUNCS_H

#include <sys/types.h>

int __mpni_io_init(void);
void __mpni_io_finalize(void);
void __mpni_io_sense(void);
int __mpni_io_send(unsigned int, void*, size_t, void*, size_t, size_t*);
int __mpni_io_rawsend(unsigned int, void*, size_t, size_t*);
int __mpni_io_psend(unsigned int, void*, size_t, void*, size_t, size_t*);
int __mpni_io_prawsend(unsigned int, void*, size_t, size_t*);
int __mpni_io_recv(unsigned int, void*, size_t, void*, size_t, int, size_t*);
int __mpni_io_rawrecv(unsigned int, void*, size_t, int, int, size_t*);
int __mpni_io_precv(unsigned int, void*, size_t, void*, size_t, int, size_t*);
int __mpni_io_prawrecv(unsigned int, void*, size_t, int, int, size_t*);
int __mpni_io_latebind(size_t, void*);
int __mpni_io_latecancel(size_t);
int __mpni_io_send_poll(size_t);
int __mpni_io_recv_poll(size_t);

#endif /* MPNI_IO_FUNCS_H */
