/*
 * <<< mpi_local.h >>>
 *
 * --- OSIRIS implementation of MPI subset 'mpi_local.h'
 *     Copyright (C) 2000-2001 Amano Lab., Keio University. ---
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef __MPI_LOCAL_H
#define __MPI_LOCAL_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/types.h>
#include "mpi.h"

size_t __mpi_local_get_sizeof_datatype(MPI_Datatype);
int __mpi_local_init(void);
void __mpi_local_finalize(void);
int __mpi_local_comm_rank(void);
int __mpi_local_comm_size(void);
__MPI_return_code __mpi_local_send(void*, size_t, unsigned int, int);
__MPI_return_code __mpi_local_receive(void*, size_t, unsigned int, int,
									  MPI_Status*);
__MPI_return_code __mpi_local_isend(void*, size_t, unsigned int, int);
__MPI_return_code __mpi_local_ireceive(void*, size_t, unsigned int, int,
									   MPI_Status*);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __MPI_LOCAL_H */
