dnl aclocal.m4 generated automatically by aclocal 1.4-p5

dnl Copyright (C) 1994, 1995-8, 1999, 2001 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

dnl Checks for package, version, library interface version.
dnl CF_CHECK_VERSION(VERSION-FILE-NAME [, LT-VERSION-FILE-NAME])
AC_DEFUN([CF_CHECK_VERSION], [
  if test -f "${srcdir}/$1"; then :; else
    AC_MSG_ERROR(Missing version file.)
  fi
  AC_MSG_CHECKING(package name)
  PACKAGE=`sed -n '1s/^\([[^  ]][[^   ]]*\) *version.*$/\1/p' ${srcdir}/$1`
  if test -z "$PACKAGE"; then
    AC_MSG_ERROR(Bad version file.)
  fi
  AC_MSG_RESULT($PACKAGE)
  AC_MSG_CHECKING(version number)
  VERSION=`sed -n '1s/^.*version *\([[0-9.]][[0-9.]]*\).*$/\1/p' ${srcdir}/$1`
  if test -z "$VERSION"; then
    AC_MSG_ERROR(Bad version file.)
  fi
  AC_MSG_RESULT($VERSION)
  AC_MSG_CHECKING(revision string)
  REVISION="`sed -n '1s/^.*version.*(\(.*\))/\1/p' ${srcdir}/$1`"
  test -z "$REVISION" && REVISION=release
  AC_MSG_RESULT($REVISION)
  MAJOR_VERSION=`echo $VERSION | sed -n 's/^\([[0-9]][[0-9]]*\).*/\1/p'`
  MINOR_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
  MICRO_VERSION=`echo $VERSION | sed -n 's/^[[0-9]][[0-9]]*\.[[0-9]][[0-9]]*\.\([[0-9]][[0-9]]*\).*/\1/p'`
  MAJOR_VERSION=`expr $MAJOR_VERSION + 0`
  MINOR_VERSION=`expr $MINOR_VERSION + 0`
  MICRO_VERSION=`expr $MICRO_VERSION + 0`
  AC_SUBST(PACKAGE)
  AC_SUBST(VERSION)
  AC_SUBST(REVISION)
  AC_SUBST(MAJOR_VERSION)
  AC_SUBST(MINOR_VERSION)
  AC_SUBST(MICRO_VERSION)
  ifelse("$2","",,[
    if test -f "${srcdir}/$2"; then :; else
      AC_MSG_ERROR(Missing lt-version file.)
    fi
    AC_MSG_CHECKING(library version)
    interface_age=`sed -n '1s/^\([[0-9]][[0-9]]*\)\..*$/\1/p' ${srcdir}/$2`
    binary_age=`sed -n '1s/^.*\.\([[0-9]][[0-9]]*\)$/\1/p' ${srcdir}/$2`
    LT_RELEASE=$MAJOR_VERSION.$MINOR_VERSION
    LT_CURRENT=`expr $MICRO_VERSION - $interface_age`
    LT_REVISION=$interface_age
    LT_AGE=`expr $binary_age - $interface_age`
    AC_MSG_RESULT([release $LT_RELEASE, version ${LT_CURRENT}.${LT_REVISION}.${LT_AGE}])
    AC_SUBST(LT_RELEASE)
    AC_SUBST(LT_CURRENT)
    AC_SUBST(LT_REVISION)
    AC_SUBST(LT_AGE)
  ])
])

dnl Checks for option for specified command.
dnl CF_CHECK_OPTION(PROGRAM-VARIABLE, FLAG-VARIABLE, OPTION)
AC_DEFUN([CF_CHECK_OPTION], [
  changequote(<<,>>)dnl
  define(<<cacheval>>, translit(cf_cv_prog_$1_$3, +-, P_))dnl
  changequote([,])dnl
  AC_CACHE_CHECK(whether [$]$1 accepts $3, cacheval, [
    echo 'int main(void) { return 0; }' > conftest.$ac_ext
    if test -z "`[$]$1 [$]$2 $3 -c conftest.$ac_ext 2>&1`"; then
      cacheval=yes
    else
      cacheval=no
    fi
    rm -fr conftest*
  ])
  if test x$cacheval = xyes; then
    if test ! x"`echo [$]$2 | sed -n 's,.*$3.*,x,p'`" = xx; then
      $2="[$]$2 $3"
    fi
  fi
])

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN([AM_INIT_AUTOMAKE],
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN([AM_SANITY_CHECK],
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN([AM_MISSING_PROG],
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN([AM_CONFIG_HEADER],
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

# Add --enable-maintainer-mode option to configure.
# From Jim Meyering

# serial 1

AC_DEFUN([AM_MAINTAINER_MODE],
[AC_MSG_CHECKING([whether to enable maintainer-specific portions of Makefiles])
  dnl maintainer-mode is disabled by default
  AC_ARG_ENABLE(maintainer-mode,
[  --enable-maintainer-mode enable make rules and dependencies not useful
                          (and sometimes confusing) to the casual installer],
      USE_MAINTAINER_MODE=$enableval,
      USE_MAINTAINER_MODE=no)
  AC_MSG_RESULT($USE_MAINTAINER_MODE)
  AM_CONDITIONAL(MAINTAINER_MODE, test $USE_MAINTAINER_MODE = yes)
  MAINT=$MAINTAINER_MODE_TRUE
  AC_SUBST(MAINT)dnl
]
)

# Define a conditional.

AC_DEFUN([AM_CONDITIONAL],
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

